<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.forms.index',
        'text' => t__('Custom Forms')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Custom Form'),
    'category' => 'forms.custom-forms.forms',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Create Custom Form') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/custom-forms" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.forms.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.forms.create') ?>" method="post" class="grid gap-4 mt-10">
        <div class="card p-6 grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input type="text" id="title" name="title" class="form-control" value="<?php _old("title"); ?>">
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="description" id="content"><?php _old('description') ?></textarea>
                </div>
            </div>
        </div>
		    <div class="card p-6 grid gap-4">
		      <?php
			      $defaultInputs = array_map(function($formQuestion, $formQuestionType, $formQuestionVariables) {
				      return [
					      'formQuestion' => $formQuestion,
					      'formQuestionType' => $formQuestionType,
					      'formQuestionVariables' => $formQuestionVariables
				      ];
			      }, old('formQuestion', []), old('formQuestionType', []), old('formQuestionVariables', []));
		      ?>
		      <div x-data="inputArray({
                      formQuestion: '',
                      formQuestionType: '',
                      formQuestionVariables: ''
                    }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
		      >
			      <div class="flex justify-between items-center">
				      <div class="card-title">
					      <?php e__('Questions') ?>
				      </div>
				      <span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
					      <i data-feather="add" class="w-4 h-4 -ml-1"></i>
					      <?php e__('Add') ?>
				      </span>
			      </div>
			      <table class="mt-3 table">
				      <colgroup>
					      <col style="width: 40%;">
					      <col style="width: 20%;">
					      <col style="width: 40%;">
				      </colgroup>
				      <thead class="">
				      <tr class="table-header !text-xs !text-gray-500">
					      <th scope="col" class="!text-left">
						      <?php e__('Question') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Type') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Variables') ?>
					      </th>
					      <th scope="col" style="width: 40px">
						      <span class="sr-only">
							      <?php e__('Actions') ?>
						      </span>
					      </th>
				      </tr>
				      </thead>
				      <tbody class="divide-y divide-gray-200/20 text-center">
				      <template x-for="(input, index) in inputs" :key="index">
					      <tr>
						      <td class="!text-left !pl-0">
							      <input type="text" class="form-control" name="formQuestion[]" x-bind:value="input.formQuestion">
						      </td>
						      <td class="!text-left !pl-0">
							      <select name="formQuestionType[]" class="form-control" x-model="input.formQuestionType">
								      <option value="1" :selected="input.formQuestionType === '1'"><?php e__("Short Text")?></option>
								      <option value="2" :selected="input.formQuestionType === '2'"><?php e__("Long Text")?></option>
								      <option value="3" :selected="input.formQuestionType === '3'"><?php e__("Single-Select")?></option>
								      <option value="4" :selected="input.formQuestionType === '4'"><?php e__("Multi-Select")?></option>
							      </select>
						      </td>
						      <td class="!text-left !pl-0">
							      <span x-show="input.formQuestionType !== '3' && input.formQuestionType !== '4'">-</span>
							      <input x-show="input.formQuestionType === '3' || input.formQuestionType === '4'" type="text" class="form-control" name="formQuestionVariables[]" x-bind:value="input.formQuestionVariables">
						      </td>
						      <td class="justify-end flex items-center !px-0" style="width: 40px;">
							      <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
								      <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
							      </div>
						      </td>
					      </tr>
				      </template>
				      </tbody>
			      </table>
		      </div>
	      </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" name="insertForms" class="btn btn-success">
                <?php e__('Create') ?>
            </button>
        </div>
    </form>
</section>
