<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.forum.threads.index',
        'text' => t__('Forum')
    ],
    [
        'url' => 'dashboard.forum.categories.index',
        'text' => t__('Categories')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Forum Category'),
    'category' => 'content-management.forum.categories',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="<?php echo $this->asset('/js/forum-permissions.js')?>"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Forum Category') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/forum/categories" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.forum.categories.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form class="grid gap-4 mt-10" action="<?php echo url('dashboard.forum.categories.create') ?>" method="post" enctype="multipart/form-data">
        <div class="card grid gap-4 p-6">
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input type="text" value="<?php _old('name') ?>" name="name" id="name" class="form-control">
            </div>
            <div>
                <label for="description" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <textarea id="description" name="description" cols="30" rows="4" class="form-control"><?php _old('description') ?></textarea>
            </div>
            <div>
                <label for="parentID" class="form-label">
                    <?php e__('Parent Category') ?>
                </label>
                <select x-data="select2Alpine()" name="parentID" id="parentID">
                    <option value="0">
                        <?php e__('None') ?>
                    </option>
                    <?php foreach ($parentCategories as $parentCategory): ?>
                        <option value="<?php echo $parentCategory["id"] ?>" <?php _selected(old('parentID') == $parentCategory["id"]); ?>>
                          <?php echo $parentCategory["name"]; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>
		    </div>
		    <div class="card grid gap-4 p-6">
			    <div>
				    <label for="forumPermissions" class="form-label pb-2">
					    <?php e__('Forum Permissions') ?>
					    <span id="syncPerms" class="text-blue-500" style="cursor: pointer; display: <?php echo old('parentID', 0) == '0' ? 'none' : 'inline-block' ?>;">(<?php e__("Sync Perms with Parent Category")?>)</span>
				    </label>
				    <table id="forumPermissions" class="table">
					    <thead class="">
					    <tr class="table-header">
						    <th scope="col" class="text-left">
							    <?php e__("Role") ?>
						    </th>
						    <?php foreach ($permissions as $permission): ?>
							    <th><?php e__($permission["description"]) ?></th>
						    <?php endforeach; ?>
					    </tr>
					    </thead>
					    <tbody class="divide-y divide-gray-200/20 text-center">
					    <tr>
						    <td class="text-left">
							    <div class="text-sm font-medium text-gray-800">
								    <?php e__('Guest') ?>
							    </div>
						    </td>
						    <?php foreach ($permissions as $permission): ?>
							    <?php if ($permission["name"] == "VIEW_FORUM"): ?>
								    <td>
									    <div class="flex justify-center">
										    <?php $this->insert('components/toggle', [
											    'name' => 'permission_0_' . $permission["id"],
											    'default' => old(('permission_0_' . $permission["id"]), '1'),
										    ]); ?>
									    </div>
								    </td>
							    <?php else: ?>
								    <td></td>
							    <?php endif; ?>
						    <?php endforeach; ?>
					    </tr>
					    <?php foreach ($roles as $role): ?>
						    <tr>
							    <td class="text-left">
								    <div class="text-sm font-medium text-gray-800">
									    <?php echo $role['name'] ?>
								    </div>
							    </td>
							    <?php foreach ($permissions as $permission): ?>
								    <td>
									    <div class="flex justify-center">
										    <?php $this->insert('components/toggle', [
											    'name' => 'permission_' . $role["id"] . '_' . $permission["id"],
											    'default' => old(('permission_' . $role["id"] . '_' . $permission["id"]), ($permission["name"] == "MODERATE_FORUM" ? '0' : "1")),
										    ]); ?>
									    </div>
								    </td>
							    <?php endforeach; ?>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
		    <div class="flex justify-end">
			    <?php _csrf(); ?>
			    <button type="submit" name="insertForumCategories" class="btn btn-success">
				    <?php e__('Create') ?>
			    </button>
		    </div>
    </form>
</section>