<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.forum.threads.index',
        'text' => t__('Forum')
    ],
    [
        'text' => t__('Threads')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Threads'),
    'category' => 'content-management.forum.threads',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($threads) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Threads') ?>
            </h1>
		        <div class="flex gap-2">
			        <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/forum/threads" class="btn btn-dark" target="_blank">
				        <?php e__('Help') ?>
			        </a>
		        </div>
        </div>
	    
	    <div class="grid mt-10">
		    <div class="los-table-actions mb-4 grid">
			    <form method="get" action="<?php echo url('dashboard.forum.threads.index') ?>" class="w-full">
				    <label for="search" class="form-label">
					    <?php e__('Search for %text%', ['%text%' => t__('Threads')]) ?>
				    </label>
				    <div class="input-absolute-group">
					    <i data-feather="search-normal"></i>
					    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
				    </div>
			    </form>
		    </div>
		    <div class="los-table">
			    <table>
				    <thead>
				    <tr>
					    <th>
						    <?php e__('Title') ?>/<?php e__('ID') ?>
					    </th>
					    <th>
						    <?php e__('Author') ?>
					    </th>
					    <th>
						    <?php e__('Category') ?>
					    </th>
					    <th class="!text-center">
						    <?php e__('Views') ?>
					    </th>
					    <th class="date">
						    <?php e__('Date') ?>
					    </th>
					    <th>
						    <span class="sr-only">
							    <?php e__('Actions') ?>
						    </span>
					    </th>
				    </tr>
				    </thead>
				    <tbody class="list">
				    <?php foreach ($threads as $thread): ?>
					    <tr>
						    <td>
							    <a href="<?php echo url('dashboard.forum.threads.edit', ['id' => $thread['id']]) ?>"><?php echo $thread['title'] ?></a>
							    <div>#<?php echo $thread['id'] ?></div>
						    </td>
						    <td>
							    <a href="<?php echo url('dashboard.accounts.show', ['id' => $thread['accountID']]) ?>" class="text-sm text-gray-500 line-clamp-2 max-w-sm block"><?php echo $thread['realname'] ?></a>
							    <div>@<?php echo $thread['username'] ?></div>
						    </td>
						    <td class="not">
							    <a href="<?php echo url('dashboard.forum.categories.edit', ['id' => $thread['categoryID']]) ?>">
								    <?php echo $thread['categoryName'] ?>
							    </a>
						    </td>
						    <td class="center">
							    <div><?php echo $thread['views'] ?></div>
							    <div><?php e__('Times Viewed') ?></div>
						    </td>
						    <td class="date">
							    <div><?php echo convertTime($thread["creationDate"], 2, true) ?></div>
							    <div><?php echo convertTime($thread["creationDate"]) ?></div>
						    </td>
						    <td class="table-action-buttons">
							    <a href="/forum/threads/<?php echo $thread['id'] ?>/<?php echo $thread['slug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
								    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
							    </a>
							    <a href="/forum/threads/<?php echo $thread['id'] ?>/edit" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
								    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
							    </a>
							    <form action="<?php echo url('dashboard.forum.threads.destroy', ['id' => $thread['id']]) ?>" method="post" x-data="deleteConfirmation()">
								    <?php _method('DELETE'); ?>
								    <?php _csrf(); ?>
								    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
									    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
								    </button>
							    </form>
						    </td>
					    </tr>
				    <?php endforeach; ?>
				    </tbody>
			    </table>
		    </div>
		    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
	    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No threads found!'),
            'details' => t__('There are no threads to show here.')
        ]);
    endif; ?>
</section>
