<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.games.index',
        'text' => t__('Games')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Game'),
    'category' => 'misc.games',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Game') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/games" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.games.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form class="grid gap-4" action="<?php echo url('dashboard.games.create') ?>" method="post" enctype="multipart/form-data">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input type="text" name="title" id="title" class="form-control" value="<?php _old('title') ?>">
            </div>

            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content') ?></textarea>
                </div>
            </div>

            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" name="insertGames" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>