<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.gaming-night.index',
        'text' => t__('Gaming Night')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Gaming Night'),
    'category' => 'store.gaming-night',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Gaming Night') ?>
        </h1>
		    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/gaming-night" class="btn btn-dark" target="_blank">
			    <?php e__('Help') ?>
		    </a>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.gaming-night.update') ?>" method="post" class="grid gap-4 mt-10">
		    <div class="card p-6">
            <?php _method('PATCH'); ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
                <div>
                    <label for="selectDay" class="form-label">
                        <?php e__('Day') ?>
                    </label>
                    <select x-data="select2Alpine()" name="day" id="selectDay">
                        <?php foreach ($days as $day): ?>
                            <option
                              value="<?php echo $day; ?>"
                              <?php _selected(old('day', moduleSettings('gaming_night', 'day')) == $day); ?>
                            >
                              <?php e__($day) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label for="start" class="form-label">
                        <?php e__('Start') ?>
                    </label>
                    <input value="<?php _old('start', $gamingNightStart[0] . $gamingNightStart[1] . ":" . $gamingNightStart[2] . $gamingNightStart[3]); ?>" type="text" name="start" id="start" class="form-control" placeholder="20:00">
                </div>
                <div>
                    <label for="end" class="form-label">
                        <?php e__('End') ?>
                    </label>
                    <input value="<?php _old('end', $gamingNightEnd[0] . $gamingNightEnd[1] . ":" . $gamingNightEnd[2] . $gamingNightEnd[3]); ?>" type="text" name="end" id="end" class="form-control" placeholder="23:59">
                </div>
            </div>
        </div>
	    
		    <div class="card p-6">
		      <div x-data="inputArray({
              productID: '',
              discountedPrice: '',
              stock: ''
            }, <?php echo htmlentities(json_encode($gamingNightProducts)) ?>)"
		           x-init="$nextTick(() => {
                   onDelete = (index) => {
                    inputs.map((input, i) => {
                      $('#input_' + i + ' select').val(input.productID).trigger('change');
                    })
                 }})"
		      >
			      <div class="flex justify-between items-center">
				      <div class="card-title">
					      <?php e__('Products') ?>
				      </div>
				      <span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
					      <i data-feather="add" class="w-4 h-4 -ml-1"></i>
					      <?php e__('Add') ?>
				      </span>
			      </div>
			      <table class="mt-3 table">
				      <colgroup>
					      <col style="width: 50%;">
					      <col style="width: 25%;">
					      <col style="width: 25%;">
				      </colgroup>
				      <thead class="">
				      <tr class="table-header !text-xs !text-gray-500">
					      <th scope="col" class="!text-left">
						      <?php e__('Product') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Discounted Price') ?>
					      </th>
					      <th scope="col" class="!text-left">
						      <?php e__('Stock') ?>
					      </th>
					      <th scope="col" style="width: 40px">
						      <span class="sr-only">
							      <?php e__('Actions') ?>
						      </span>
					      </th>
				      </tr>
				      </thead>
				      <tbody class="divide-y divide-gray-200/20 text-center">
				      <template x-for="(input, index) in inputs" :key="index">
					      <tr x-bind:id="'input_' + index">
						      <td class="!text-left !pl-0">
							      <label class="sr-only">
								      <?php e__('Product') ?>
							      </label>
							      <?php $this->insert('components/select-product', [
								      'name' => 'product[]',
								      'placeholder' => t__('Select product'),
								      'selectedJS' => 'input.productID',
								      'list' => $productList
							      ]); ?>
						      </td>
						      <td class="!text-left !pl-0">
							      <input type="text" class="form-control" name="discountedPrice[]" x-bind:value="input.discountedPrice">
						      </td>
						      <td class="!text-left !pl-0">
							      <input type="text" class="form-control" name="stock[]" x-bind:value="input.stock">
						      </td>
						      <td class="justify-end flex items-center !px-0" style="width: 40px;">
							      <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
								      <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
							      </div>
						      </td>
					      </tr>
				      </template>
				      </tbody>
			      </table>
		      </div>
	      </div>
	    
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Save Changes') ?>
            </button>
        </div>
    </form>
</section>
