<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.gifts.index',
        'text' => t__('Gifts')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Gift'),
    'category' => 'store.gifts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Gift') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/gifts" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
		      <a href="<?php echo url('dashboard.gifts.index') ?>" class="btn btn-default">
		          <?php e__('Back') ?>
		      </a>
	      </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.gifts.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="name" class="form-label">
                    <?php e__('Gift Code') ?>
                </label>
		            <div class="input-absolute-group-right" x-data="generateRandomCode()">
			            <input x-ref="codeInput" value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
			            <div>
				            <button @click="generate" type="button" class="flex items-center justify-center gap-1 btn btn-dark !text-sm !px-2.5 !py-1 !rounded-md">
					            <i data-feather="refresh" class="w-4 h-4"></i>
					            <span><?php e__('Generate') ?></span>
				            </button>
			            </div>
		            </div>
            </div>

            <div class="grid gap-4" x-data="{giftType: '<?php _old('giftType', 1); ?>'}">
                <div>
                    <label for="giftType" class="form-label">
                        <?php e__('Gift Type') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('giftType',() => giftType=selected)" name="giftType" id="giftType">
                        <option value="1" <?php _selected(old('giftType') == 1); ?>>
                            <?php e__('Product') ?>
                        </option>
                        <option value="2" <?php _selected(old('giftType') == 2); ?>>
                            <?php e__('Credit') ?>
                        </option>
                    </select>
                </div>

                <div x-show="giftType === '1'">
                    <div>
                        <label for="giftProduct" class="form-label">
                            <?php e__('Product') ?>
                        </label>
                        <?php $this->insert('components/select-product', [
                            'name' => 'giftProduct',
                            'id' => 'giftProduct',
                            'placeholder' => t__('Select product'),
                            'selected' => old('giftProduct'),
                            'list' => $productList,
                        ]); ?>
                    </div>
                </div>
	            
		            <div x-show="giftType === '2'">
			            <label for="giftCredit" class="form-label">
				            <?php e__('Credit Amount') ?>
			            </label>
			            <input type="text" id="giftCredit" name="giftCredit" class="form-control">
		            </div>
            </div>
	        
		        <div>
			        <label for="expiryDate" class="form-label">
				        <?php e__('Expiry Date') ?>
			        </label>
			        <div class="input-group" x-data="datePickerWithCheckbox('<?php _old('expiryDate', "1000-01-01 00:00:00") ?>')">
				        <div class="input-group-prepend">
					        <div class="input-group-text">
						        <i data-feather="calendar-2"></i>
					        </div>
				        </div>
				        <input
					        x-ref="datepicker"
					        type="text"
					        id="expiryDate"
					        name="expiryDate"
					        class="form-control !pl-0"
					        data-placeholder="<?php e__('Select date') ?>"
					        :disabled="isDisabled"
				        >
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="neverExpires"
								        class="form-checkbox"
								        id="neverExpires"
								        x-ref="neverCheckbox"
								        @click="toggleCheckbox"
							        >
							        <label class="form-label select-none !mb-0" for="neverExpires">
								        <?php e__('Never') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>
	        
		        <div>
			        <label for="redeemLimit" class="form-label">
				        <?php e__('Redeem Limit') ?>
			        </label>
			        <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('redeemLimit', "-1") ?>">
				        <input type="number" id="redeemLimit" name="redeemLimit" class="form-control">
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="unlimitedRedeemLimit"
								        class="form-checkbox"
								        id="unlimitedRedeemLimit"
							        >
							        <label class="form-label select-none !mb-0" for="unlimitedRedeemLimit">
								        <?php e__('Unlimited') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>
