<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.gifts.index',
        'text' => t__('Gifts')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $gift['name']]),
    'category' => 'store.gifts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $gift['name']]) ?>
        </h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/gifts" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.gifts.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.gifts.update', ['id' => $gift['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Coupon Code') ?>
                </label>
                <input value="<?php _old('name', $gift['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>

            <div class="grid gap-4" x-data="{giftType: '<?php _old('giftType', $gift["giftType"]); ?>'}">
                <div>
                    <label for="giftType" class="form-label">
                        <?php e__('Gift Type') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('giftType',() => giftType=selected)" name="giftType" id="giftType">
                        <option value="1" <?php _selected(old('giftType', $gift["giftType"]) == 1); ?>>
                            <?php e__('Product') ?>
                        </option>
                        <option value="2" <?php _selected(old('giftType', $gift["giftType"]) == 2); ?>>
                            <?php e__('Credit') ?>
                        </option>
                    </select>
                </div>

                <div x-show="giftType === '1'">
                    <div>
                        <label for="giftProduct" class="form-label">
                            <?php e__('Product') ?>
                        </label>
                        <?php $this->insert('components/select-product', [
                            'name' => 'giftProduct',
                            'id' => 'giftProduct',
                            'selected' => old('giftProduct', ($gift["giftType"] == 1 ? $gift['gift'] : null)),
                            'placeholder' => t__('Select product'),
                            'list' => $productList,
                        ]); ?>
                    </div>
                </div>

                <div x-show="giftType === '2'">
                    <label for="giftCredit" class="form-label">
                        <?php e__('Credit Amount') ?>
                    </label>
                    <input type="text" id="giftCredit" name="giftCredit" class="form-control" value="<?php _old('giftCredit', ($gift["giftType"] == 2 ? $gift["gift"] : null)) ?>">
                </div>
            </div>
	        
		        <div>
			        <label for="expiryDate" class="form-label">
				        <?php e__('Expiry Date') ?>
			        </label>
			        <div class="input-group" x-data="datePickerWithCheckbox('<?php _old('expiryDate', $gift['expiryDate']) ?>')">
				        <div class="input-group-prepend">
					        <div class="input-group-text">
						        <i data-feather="calendar-2"></i>
					        </div>
				        </div>
				        <input
					        x-ref="datepicker"
					        type="text"
					        id="expiryDate"
					        name="expiryDate"
					        class="form-control !pl-0"
					        data-placeholder="<?php e__('Select date') ?>"
					        :disabled="isDisabled"
				        >
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="neverExpires"
								        class="form-checkbox"
								        id="neverExpires"
								        x-ref="neverCheckbox"
								        @click="toggleCheckbox"
							        >
							        <label class="form-label select-none !mb-0" for="neverExpires">
								        <?php e__('Never') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>
	        
		        <div>
			        <label for="redeemLimit" class="form-label">
				        <?php e__('Redeem Limit') ?>
			        </label>
			        <div class="input-group" data-toggle="unlimited-input" data-limit="<?php _old('redeemLimit', $gift['redeemLimit']) ?>">
				        <input type="number" id="redeemLimit" name="redeemLimit" class="form-control">
				        <div class="input-group-append">
					        <div class="input-group-text !bg-neutral-900">
						        <div class="flex gap-2 items-center">
							        <input
								        type="checkbox"
								        name="unlimitedRedeemLimit"
								        class="form-checkbox"
								        id="unlimitedRedeemLimit"
							        >
							        <label class="form-label select-none !mb-0" for="unlimitedRedeemLimit">
								        <?php e__('Unlimited') ?>
							        </label>
						        </div>
					        </div>
				        </div>
			        </div>
		        </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>
