<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.gifts.index',
        'text' => t__('Gifts')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Gifts'),
    'category' => 'store.gifts',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($gifts) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Gifts') ?>
            </h1>
            <a href="<?php echo url('dashboard.gifts.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Gifts')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="product">
								    <?php e__('Product') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="duration">
								    <?php e__('Expiry Date') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="amount">
								    <?php e__('Redeem Limit') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="couponLeft">
								    <?php e__('Left') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($gifts as $gift): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.gifts.edit', ['id' => $gift['id']]) ?>" class="name"><?php echo $gift['name'] ?></a>
								    <p class="text-xs text-gray-500">#<?php echo $gift['id'] ?></p>
							    </td>
							    <td class="product">
								    <?php echo $gift['productName'] ?>
							    </td>
							    <td class="duration center">
								    <?php if ($gift["expiryDate"] == '1000-01-01 00:00:00'): ?>
									    <?php e__('Lifetime') ?>
								    <?php else: ?>
									    <div><?php echo getDuration($gift["expiryDate"]) ?></div>
									    <div>
										    <?php e__('Day') ?>
									    </div>
								    <?php endif; ?>
							    </td>
							    <td class="amount center">
								    <?php if ($gift["redeemLimit"] == -1): ?>
									    <?php e__('Unlimited') ?>
								    <?php else: ?>
									    <?php echo $gift["redeemLimit"] ?>
								    <?php endif; ?>
							    </td>
							    <td class="couponLeft center">
								    <?php if ($gift["redeemLimit"] == -1): ?>
									    <?php e__('Unlimited') ?>
								    <?php else: ?>
									    <?php echo $gift['amountLeft'] ?>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($gift["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($gift["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.gifts.edit', ['id' => $gift['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.gifts.destroy', ['id' => $gift['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No gifts found!'),
            'details' => t__('You can create a new gift by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.gifts.create',
                'text' => t__('Create Gift')
            ],
        ]);
    endif; ?>
</section>
