<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.gifts.index',
        'text' => t__('Gifts')
    ],
    [
        'url' => 'dashboard.gifts.logs',
        'text' => t__('Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Gift Logs'),
    'category' => 'logs.gift',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($giftLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Gift Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.gifts.logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Gift Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Name') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Receiver') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($giftLogs as $giftLog): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.gifts.logs.show', ['id' => $giftLog['id']]) ?>"><?php echo $giftLog['giftTitle'] ?></a>
								    <div>#<?php echo $giftLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $giftLog['accountID']]) ?>"><?php echo $giftLog['realname'] ?></a>
								    <div>@<?php echo $giftLog['username'] ?></div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($giftLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($giftLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.gifts.logs.show', ['id' => $giftLog['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <form action="<?php echo url('dashboard.gifts.logs.destroy', ['id' => $giftLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No gift logs found'),
            'details' => t__('There are no gift logs to show here.')
        ]);
    endif; ?>
</section>
