<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.help.articles.index',
        'text' => t__('Help Center')
    ],
    [
        'url' => 'dashboard.help.articles.index',
        'text' => t__('Articles')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Article'),
    'category' => 'support-help.help.articles',
    'breadcrumbs' => $breadcrumbs
]) ?>
<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Article'); ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/help-center/articles" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.help.articles.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.help.articles.create') ?>" method="post" class="grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>
            <div>
                <label for="topic" class="form-label">
                    <?php e__('Topic') ?>
                </label>
                <select x-data="select2Alpine()" name="topicID" id="topicID">
                    <?php if (count($topics) > 0): ?>
                        <?php foreach ($topics as $topic): ?>
                            <option value="<?php echo $topic["id"] ?>"><?php echo $topic["name"] ?></option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value=""><?php e__('No data found!') ?></option>
                    <?php endif; ?>
                </select>
            </div>

            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2 relative">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="content" id="content"><?php _old('content') ?></textarea>
		                <?php $this->insert('components/ai/generate-button', [
			                'target' => '#content',
			                'type' => 'help_center_article',
		                ]) ?>
                </div>
            </div>
	        
		        <div>
			        <label for="order" class="form-label">
				        <?php e__('Order') ?>
			        </label>
			        <input value="<?php _old('order', 0) ?>" type="number" name="order" id="order" class="form-control">
		        </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Publish') ?>
                </button>
            </div>
        </form>
    </div>
</section>

