<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.help.articles.index',
        'text' => t__('Help Center')
    ],
    [
        'text' => t__('Articles')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Articles'),
    'category' => 'support-help.help.articles',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($articles) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Articles') ?>
            </h1>
            <a href="<?php echo url('dashboard.help.articles.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.help.articles.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Articles')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Title') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('Author') ?>
						    </th>
						    <th>
							    <?php e__('Category') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Views') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Helpfulness') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($articles as $article): ?>
						    <tr>
							    <td>
								    <a href=""><?php echo $article['title'] ?></a>
								    <div>#<?php echo $article['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $article['accountID']]) ?>"><?php echo $article['realname'] ?></a>
								    <div>@<?php echo $article['username'] ?></div>
							    </td>
							    <td>
								    <?php echo $article['topicName'] ?>
							    </td>
							    <td class="center">
								    <div><?php echo $article['views'] ?></div>
								    <div><?php e__('Times Viewed') ?></div>
							    </td>
							    <td class="center">
								    <div><?php echo $article["likesCount"] . '/' . $article["dislikesCount"] ?></div>
								    <?php if ($article["usefulPercent"] != 0): ?>
									    <?php if ($article["usefulPercent"] < 50): ?>
										    <span class="text-xs text-danger">(<?php echo $article["usefulPercent"]; ?>%)</span>
									    <?php elseif ($article["usefulPercent"] < 75): ?>
										    <span class="text-xs text-warning">(<?php echo $article["usefulPercent"]; ?>%)</span>
									    <?php else: ?>
										    <span class="text-xs text-success">(<?php echo $article["usefulPercent"]; ?>%)</span>
									    <?php endif; ?>
								    <?php else: ?>
									    (-%)
								    <?php endif ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($article["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($article["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/help/articles/<?php echo $article["id"] ?>/<?php echo $article["slug"] ?>" x-bind="tooltip('<?php e__('View') ?>')" target="_blank" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.help.articles.edit', ['id' => $article['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.help.articles.destroy', ['id' => $article['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No articles found!'),
            'details' => t__('You can create a new article by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.help.articles.create',
                'text' => t__('Create Article')
            ],
        ]);
    endif; ?>
</section>
