<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.help.articles.index',
        'text' => t__('Help Center')
    ],
    [
        'url' => 'dashboard.help.topics.index',
        'text' => t__('Topics')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Add Topic'),
    'category' => 'support-help.help.topics',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Topic'); ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/help-center/topics" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.help.topics.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.help.topics.create') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div x-data="textEditor()">
                <label for="description" class="form-label">
                    <?php e__('Description') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="description" id="description"><?php _old('description') ?></textarea>
                </div>
            </div>
	        
		        <div>
			        <label for="order" class="form-label">
				        <?php e__('Order') ?>
			        </label>
			        <input value="<?php _old('order', 0) ?>" type="number" name="order" id="order" class="form-control">
		        </div>

            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

