<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.home',
        'text' => t__('Overview')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Dashboard'),
    'category' => 'dashboard',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script>
  var $onlineAPI = "<?php echo settings('onlineAPI') ?>";
</script>
<script src="<?php echo $this->asset('/js/online-players.js')?>"></script>
<?php $this->end() ?>

<section class="los-container !mb-20">
    <div class="grid">
		    <?php if (getDuration(getSubsExpiryDate()) <= 3 && auth()->user()->can('SUPER_ADMIN')): ?>
			    <?php $subsDuration = getDuration(getSubsExpiryDate()); ?>
			    <?php if ($subsDuration == 0): ?>
				    <div class="alert alert-warning flex flex-col lg:flex-row lg:justify-between lg:items-center mb-6">
					    <div>
						    <p class="text-lg font-medium text-gray-950 mb-2">
							    <?php e__('Subscription Expiring!'); ?>
						    </p>
						    <p class="text-gray-600">
							    <?php e__('Your subscription will expire today. Please renew your subscription to continue using the service.'); ?>
						    </p>
					    </div>
					    <div class="mt-2">
						    <a href="<?php echo leaderosRenewSubsUrl() ?>" class="btn btn-success !py-3 !px-5">
							    <?php e__('Renew Subscription') ?>
						    </a>
					    </div>
				    </div>
			    <?php else: ?>
				    <div class="alert alert-warning flex flex-col lg:flex-row lg:justify-between lg:items-center mb-6">
					    <div>
						    <p class="text-lg font-medium text-gray-950 mb-2">
							    <?php e__('Subscription Expiring!'); ?>
						    </p>
						    <p class="text-gray-600">
							    <?php e__('Your subscription will expire in %days% days. Please renew your subscription to continue using the service.', ['%days%' => $subsDuration]); ?>
						    </p>
					    </div>
					    <div class="mt-2">
						    <a href="<?php echo leaderosRenewSubsUrl() ?>" class="btn btn-success !py-3 !px-5">
							    <?php e__('Renew Subscription') ?>
						    </a>
					    </div>
				    </div>
			    <?php endif; ?>
		    <?php endif; ?>
	    
		    <?php if (settings('updateNotifications') == 1): ?>
			    <?php if (isNeedUpdate() && auth()->user()->can('MANAGE_UPDATES')): ?>
				    <div class="alert alert-primary flex flex-col lg:flex-row lg:justify-between lg:items-center mb-6">
					    <div>
						    <p class="text-lg font-medium text-gray-950 mb-2">
							    <?php e__('Updates available!'); ?>
						    </p>
						    <p class="text-gray-600">
							    <?php e__('A new LeaderOS update is out! Click Update button to use the latest version.'); ?>
						    </p>
					    </div>
					    <div class="mt-2">
						    <a href="<?php echo url('dashboard.updates.index') ?>" class="btn btn-success !py-3 !px-5">
							    <?php e__('Update') ?>
						    </a>
					    </div>
				    </div>
			    <?php elseif (isNeedThemeUpdate() && auth()->user()->can('MANAGE_UPDATES')): ?>
				    <div class="alert alert-primary flex flex-col lg:flex-row lg:justify-between lg:items-center mb-6">
					    <div>
						    <p class="text-lg font-medium text-gray-950 mb-2">
							    <?php e__('Updates available!'); ?>
						    </p>
						    <p class="text-gray-600">
							    <?php e__('A new Theme update is out! Click Update button to use the latest version.'); ?>
						    </p>
					    </div>
					    <div class="mt-2">
						    <a href="<?php echo url('dashboard.appearance.themes.update.index') ?>" class="btn btn-success !py-3 !px-5">
							    <?php e__('Update') ?>
						    </a>
					    </div>
				    </div>
			    <?php endif; ?>
		    <?php endif; ?>
	    
        <h1 class="text-gray-800 !text-[1.625rem]">
            <?php e__('Overview') ?>
        </h1>

        <?php if (auth()->user()->can(['VIEW_STATS'])): ?>
          <div class="mt-10 card" x-data="tab('sales')">
            <div x-data="overviewChart">
              <div class="flex flex-col md:flex-row justify-between items-center px-6">
                <div class="pt-6 lg:p-6 h4 text-gray-800">
                  <div x-show="activeTab === 'sales'">
                    <?php e__('Sales') ?>
                  </div>
                  <div x-show="activeTab === 'reg'">
                    <?php e__('Registrations') ?>
                  </div>
                </div>
                <div class="tab-container !flex-row gap-1 !pb-0">
                  <div @click="openTab('sales'); updateData('earn');" :class="{'active':activeTab === 'sales'}" class="tab-item !px-5 !lg:px-10 active center flex-col">
                    <span><?php e__('Sales') ?></span>
                    <div x-show="!chartEarnCache.isLoading" class="mt-2 text-lg font-semibold">
                      <span x-text="chartEarnCache.total"></span>
                      <span class="font-light">
                        <?php echo settings('currency'); ?>
                      </span>
                    </div>
                    <div x-show="chartEarnCache.isLoading" class="mt-2 text-lg font-semibold">
                      <svg class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                        <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                      </svg>
                    </div>
                  </div>
                  <div @click="openTab('reg'); updateData('user')" class="tab-item !px-5 !lg:px-10 center flex-col" :class="{'active':activeTab === 'reg'}">
                    <span><?php e__('Registrations') ?></span>
                    <div x-show="!chartUserCache.isLoading" x-text="chartUserCache.total" class="mt-2 text-lg font-bold"></div>
                    <div x-show="chartUserCache.isLoading" class="mt-2 text-lg font-semibold">
                      <svg class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                        <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                      </svg>
                    </div>
                  </div>
                </div>
              </div>

              <div class="pt-4 pb-10 px-6">
                <canvas x-ref="chart" class="!w-full" height="100"></canvas>
              </div>
            </div>
          </div>
        <?php endif; ?>

        <div class="mt-10 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
            <?php if (auth()->user()->can('MANAGE_ACCOUNTS')): ?>
                <div x-data="cardData('user')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="user"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("Registered User") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.totalAccountCount"></p>
                            <span :class="badgeClass(calculator(data?.thisMonthAccountCount,data?.lastMonthAccountCount))" class="badge badge-sm mt-1" x-text="calculator(data?.thisMonthAccountCount,data?.lastMonthAccountCount)+'%'"></span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (auth()->user()->can('SUPER_ADMIN')): ?>
                <div x-data="cardData('today-earn')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="dollar-circle"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("Today Sales") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.todayEarnedMoney"></p>
                            <span :class="badgeClass(calculator(data?.todayEarnedMoney,data?.yesterdayEarnedMoney))" class="badge badge-sm mt-1" x-text="calculator(data?.todayEarnedMoney,data?.yesterdayEarnedMoney)+'%'"></span>
                        </div>
                    </div>
                </div>

                <div x-data="cardData('this-month-earn')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="dollar-circle"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("This Month Sales") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.thisMonthEarnedMoney"></p>
                            <span :class="badgeClass(calculator(data?.thisMonthEarnedMoney,data?.lastMonthEarnedMoney))" class="badge badge-sm mt-1" x-text="calculator(data?.thisMonthEarnedMoney,data?.lastMonthEarnedMoney)+'%'"></span>

                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (auth()->user()->can('MANAGE_BLOG')): ?>
                <div x-data="cardData('waiting-comments')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="copy-success"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("Pending Comments") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.rowCount"></p>
                        </div>
                    </div>
                </div>
                <div x-data="cardData('this-month-blog-posts')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="message-edit"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("This Month News") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.rowCount"></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (auth()->user()->can('MANAGE_SUPPORT') || auth()->user()->can('MANAGE_SUPPORT_TICKETS')): ?>
                <div x-data="cardData('this-month-support-tickets')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="message-text"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("This Month Supports") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.rowCount"></p>
                        </div>
                    </div>
                </div>
                <div x-data="cardData('waiting-support-tickets')" class="card p-6 flex gap-3 items-start">
                    <div class="w-10 h-10 center rounded-xl bg-gray-100">
                        <i class="stroke-blue-500 dark:stroke-white" data-feather="message-text"></i>
                    </div>
                    <div>
                        <div class="text-gray-400/75 font-medium text-sm"><?php e__("Supports Waiting Reply") ?></div>
                        <div class="flex gap-2 items-start">
                            <svg x-show="!process" class="animate-spin h-5 w-5" opacity=".75" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="stroke-gray-400" cx="12" cy="12" r="10" stroke-width="3"></circle>
                                <path class="fill-gray-800" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>

                            <p x-show="process" class="h3 text-gray-800" x-text="data?.rowCount"></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card p-6 flex gap-3 items-start">
                <div class="w-10 h-10 center rounded-xl bg-gray-100">
                    <i class="stroke-blue-500 dark:stroke-white" data-feather="global"></i>
                </div>
                <div>
                    <div class="text-gray-400/75 font-medium text-sm"><?php e__("Online Players") ?></div>
                    <div class="flex gap-2 items-start">
                        <p class="font-medium text-gray-800" data-toggle="onlinetext" server-ip="<?php echo settings('serverIP') ?>">-</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-20 grid xl:grid-cols-2 gap-4">
            <?php if (count($orders) > 0): ?>
                <div>
		                <div class="card rounded-2xl border border-gray-200/50 px-5 pt-3 pb-2">
                        <div class="flex justify-between items-center">
                            <h5 class="card-title">
                                <?php e__('Latest Purchases') ?>
                            </h5>
                            <a href="<?php echo url('dashboard.store.orders.index') ?>" class="btn btn-sm btn-default">
                                <?php e__('Show All') ?>
                            </a>
                        </div>
                        <div class="mt-4">
                            <table class="table">
                                <colgroup>
                                    <col style="width: 60%;">
                                    <col style="width: 40%;">
                                </colgroup>
                                <thead>
                                <tr class="table-header">
                                    <th>
                                        <?php e__('User') ?>
                                    </th>
                                    <th class="text-right">
                                        <?php e__('Amount') ?>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($orders as $order): ?>
                                    <tr>
                                        <td class="!text-left">
                                            <a href="<?php echo url('dashboard.accounts.show', ['id' => $order["accountID"]]); ?>" class="flex gap-2 items-center">
                                                <?php echo $order["realname"] ?>
                                            </a>
	                                          <div class="text-sm text-gray-500">
		                                          @<?php echo $order["username"]; ?>
	                                          </div>
                                        </td>
                                        <td class="text-right">
                                            <?php echo money($order["total"]); ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if (count($tickets) > 0): ?>
                <div>
                    <div class="card rounded-2xl border border-gray-200/50 px-5 pt-3 pb-2">
                        <div class="flex justify-between items-center">
                            <h5 class="card-title">
                                <?php e__('Latest Tickets') ?>
                            </h5>
                            <a href="<?php echo url('dashboard.support.tickets.index') ?>" class="btn btn-sm btn-default">
                                <?php e__('Show All') ?>
                            </a>
                        </div>
                        <div class="mt-4">
                            <table class="table">
                                <colgroup>
                                    <col style="width: 60%;">
                                    <col style="width: 40%;">
                                </colgroup>
                                <thead>
                                <tr class="table-header">
                                    <th>
                                        <?php e__('Title') ?>
                                    </th>
                                    <th class="text-right">
                        <span class="sr-only">
                          <?php e__('Actions') ?>
                        </span>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($tickets as $ticket): ?>
                                    <tr>
                                        <td class="!text-left">
                                            <a href="<?php echo url('dashboard.support.tickets.show', ['id' => $ticket["id"]]) ?>" class="flex gap-2 items-center">
                                                <?php echo limitedContent($ticket["title"], 20) ?>
                                            </a>
                                        </td>
                                        <td class="flex justify-end">
                                            <a href="<?php echo url('dashboard.support.tickets.show', ['id' => $ticket["id"]]) ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary btn-sheer">
                                                <i class="stroke-primary-500 stroke-2 w-3" data-feather="eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<script>
    // Reload Cache
    axios.get('<?php echo url('dashboard.ajax.stats') ?>?target=check&action=account-cache');
    axios.get('<?php echo url('dashboard.ajax.stats') ?>?target=check&action=currency-cache');
</script>

<?php if (settings('websiteURL') == '' || settings('websiteURL') == null): ?>
  <script>
      axios.get('<?php echo url('dashboard.ajax.stats') ?>?target=check&action=website-url');
  </script>
<?php endif; ?>
