<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.leaderboards.index',
        'text' => t__('Leaderboards')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $leaderboard['serverName']]),
    'category' => 'misc.leaderboards',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $leaderboard['serverName']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/leaderboards" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.leaderboards.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.leaderboards.update', ['id' => $leaderboard['id']]) ?>" method="post" class="grid gap-4 mt-10">
        <div class="card p-6 grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
                <label for="serverName" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('serverName', $leaderboard['serverName']) ?>" type="text" id="serverName" name="serverName" class="form-control" >
            </div>
            <div x-data="{mysqlServerStatus: '<?php echo old('mysqlServerStatus', $leaderboard["mysqlServer"]) == '0' ? '0' : '1' ?>'}">
                <div>
                    <label for="mysqlServerStatus" class="form-label">
                        <?php e__('MySQL Connection') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('select',() => mysqlServerStatus=selected)" name="mysqlServerStatus" id="mysqlServerStatus" required>
                        <option value="0" <?php _selected(old('mysqlServerStatus', $leaderboard["mysqlServer"]) == '0'); ?>>
                            <?php e__('Connect this server') ?>
                        </option>
                        <option value="1" <?php _selected(old('mysqlServerStatus', $leaderboard["mysqlServer"]) != '0'); ?>>
                            <?php e__('Connect another server') ?>
                        </option>
                    </select>
                </div>

                <div x-show="mysqlServerStatus === '1'" class="flex flex-col gap-4 mt-4">
                    <div class="grid lg:grid-cols-2 gap-4">
                        <div>
                            <label for="mysqlServer" class="form-label">
                                <?php e__('MySQL Host') ?>
                            </label>
                            <input value="<?php _old('mysqlServer', $leaderboard['mysqlServer'] != "0" ? $leaderboard['mysqlServer'] : null) ?>" id="mysqlServer" type="text" name="mysqlServer" class="form-control">
                        </div>
                        <div>
                            <label for="mysqlPort" class="form-label">
                                <?php e__('MySQL Port') ?>
                            </label>
                            <input value="<?php _old('mysqlPort', $leaderboard['mysqlPort'] != "0" ? $leaderboard['mysqlPort'] : null) ?>" id="mysqlPort" type="text" name="mysqlPort" class="form-control">
                        </div>
                        <div>
                            <label for="mysqlUsername" class="form-label">
                                <?php e__('MySQL Username') ?>
                            </label>
                            <input value="<?php _old('mysqlUsername', $leaderboard['mysqlUsername'] != "0" ? $leaderboard['mysqlUsername'] : null) ?>" id="mysqlUsername" type="text" name="mysqlUsername" class="form-control">
                        </div>
                        <div>
                            <label for="mysqlPassword" class="form-label">
                                <?php e__('MySQL Password') ?>
                            </label>
                            <input value="<?php _old('mysqlPassword', $leaderboard['mysqlPassword'] != "0" ? $leaderboard['mysqlPassword'] : null) ?>" id="mysqlPassword" type="text" name="mysqlPassword" class="form-control">
                        </div>
                    </div>
                    <div>
                        <label for="mysqlDatabase" class="form-label">
                            <?php e__('MySQL Database') ?>
                        </label>
                        <input value="<?php _old('mysqlDatabase', $leaderboard['mysqlDatabase'] != "0" ? $leaderboard['mysqlDatabase'] : null) ?>" id="mysqlDatabase" type="text" name="mysqlDatabase" class="form-control">
                    </div>
                    <div class="mb-4">
                        <button type="button" @click="checkSqlConnection()" class="btn btn-default flex items-center">
                          <svg style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                          </svg>
                          <span>
                            <?php e__('Check Database Connection') ?>
                          </span>
                        </button>
                    </div>
                </div>
            </div>
            <div>
                <label for="mysqlTable" class="form-label">
                    <?php e__('MySQL Table') ?>
                </label>
                <input value="<?php _old('mysqlTable', $leaderboard['mysqlTable']) ?>" type="text" id="mysqlTable" name="mysqlTable" class="form-control" required>
            </div>
            <div>
                <label for="usernameColumn" class="form-label">
                    <?php e__('Username Column') ?>
                </label>
                <input value="<?php _old('usernameColumn', $leaderboard['usernameColumn']) ?>" type="text" id="usernameColumn" name="usernameColumn" class="form-control" required>
            </div>
            <div>
                <label for="sorter" class="form-label">
                    <?php e__('Sorter Column') ?>
                </label>
                <input value="<?php _old('sorter', $leaderboard['sorter']) ?>" type="text" id="sorter" name="sorter" class="form-control" required>
            </div>
            <div>
                <label for="dataLimit" class="form-label">
                    <?php e__('Data Limit') ?>
                </label>
                <select x-data="select2Alpine()" name="dataLimit" id="dataLimit" required>
                    <option value="10" <?php _selected(old('dataLimit', $leaderboard["dataLimit"]) == 10); ?>>
                        10
                    </option>
                    <option value="25" <?php _selected(old('dataLimit', $leaderboard["dataLimit"]) == 25); ?>>
                        25
                    </option>
                    <option value="50" <?php _selected(old('dataLimit', $leaderboard["dataLimit"]) == 50); ?>>
                        50
                    </option>
                    <option value="100" <?php _selected(old('dataLimit', $leaderboard["dataLimit"]) == 100); ?>>
                        100
                    </option>
                </select>
            </div>
        </div>
		    <div class="card p-6 grid gap-4">
			    <?php
				    $defaultInputs = [];
				    if (old('tableTitles', explode(',', $leaderboard['tableTitles'])) !== null && old('tableData', explode(',', $leaderboard['tableData'])) !== null) {
					    $defaultInputs = array_map(function($title, $data) {
						    return [
							    'tableTitles' => $title,
							    'tableData' => $data
						    ];
					    }, old('tableTitles', explode(',', $leaderboard['tableTitles'])), old('tableData', explode(',', $leaderboard['tableData'])));
				    }
			    ?>
			    <div x-data="inputArray({
                  tableTitles: '',
                  tableData: ''
                }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
			    >
				    <div class="flex justify-between items-center">
					    <div class="card-title">
						    <?php e__('Table Columns') ?>
					    </div>
					    <span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
						    <i data-feather="add" class="w-4 h-4 -ml-1"></i>
						    <?php e__('Add') ?>
					    </span>
				    </div>
				    <table class="mt-3 table">
					    <thead class="">
					    <tr class="table-header !text-xs !text-gray-500">
						    <th scope="col" class="!text-left">
							    <?php e__('Title') ?>
						    </th>
						    <th scope="col" class="!text-left">
							    <?php e__('Database Column Name') ?>
						    </th>
						    <th scope="col" style="width: 40px">
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="divide-y divide-gray-200/20 text-center">
					    <template x-for="(input, index) in inputs" :key="index">
						    <tr>
							    <td class="!text-left !pl-0">
								    <input type="text" class="form-control" name="tableTitles[]" x-bind:value="input.tableTitles">
							    </td>
							    <td class="!text-left !pl-0">
								    <input type="text" class="form-control" name="tableData[]" x-bind:value="input.tableData">
							    </td>
							    <td class="justify-end flex items-center !px-0" style="width: 40px;">
								    <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
									    <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
								    </div>
							    </td>
						    </tr>
					    </template>
					    </tbody>
				    </table>
			    </div>
		    </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Save Changes') ?>
            </button>
        </div>
    </form>
</section>
