<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.leaderboards.index',
        'text' => t__('Leaderboards')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Leaderboards'),
    'category' => 'misc.leaderboards',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($leaderboards) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php echo t__('Leaderboards') ?>
            </h1>
            <a href="<?php echo url('dashboard.leaderboards.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Leaderboards')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="server">
								    <?php e__('Server') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="sqlTable">
								    <?php e__('MySQL Table') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="sorter">
								    <?php e__('Sorter') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="dataLimit">
								    <?php e__('Data limit') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($leaderboards as $leaderboard): ?>
						    <tr>
							    <td class="text-left">
								    <a href="<?php echo url('dashboard.leaderboards.edit', ['id' => $leaderboard['id']]) ?>" class="server"><?php echo $leaderboard['serverName'] ?></a>
								    <div>#<?php echo $leaderboard['id'] ?></div>
							    </td>
							    <td class="sqlTable">
								    <?php echo $leaderboard['mysqlTable'] ?>
							    </td>
							    <td class="sorter">
								    <?php echo $leaderboard['sorter'] ?>
							    </td>
							    <td class="dataLimit">
								    <?php echo $leaderboard['dataLimit'] ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/leaderboards/<?php echo $leaderboard['serverSlug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.leaderboards.edit', ['id' => $leaderboard['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.leaderboards.destroy', ['id' => $leaderboard['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No leaderboards found!'),
            'details' => t__('You can add new leaderboards by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.leaderboards.create',
                'text' => t__('Create Leaderboard')
            ],
        ]);
    endif; ?>
</section>
