<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.logs.index',
        'text' => t__('Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Logs'),
    'category' => 'logs.dashboard',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($logs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 !grid grid-cols-12">
				    <div class="col-span-9">
					    <form method="get" action="<?php echo url('dashboard.logs.index') ?>" class="w-full">
						    <label for="search" class="form-label">
							    <?php e__('Search for %text%', ['%text%' => t__('Logs')]) ?>
						    </label>
						    <div class="input-absolute-group">
							    <i data-feather="search-normal"></i>
							    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
						    </div>
					    </form>
				    </div>
				    <div class="col-span-3">
					    <div class="flex w-full h-full">
						    <div x-data="dropdown()" class="relative w-full">
							    <label class="form-label">
								    <?php e__('Action') ?>
							    </label>
							    <div @click="toggle()" class="btn btn-sm btn-input">
								    <span x-text="selected"></span>
								    <i data-feather="arrow-down" class="w-4 h-4"></i>
							    </div>
							    
							    <div x-bind="isDropdown" class="dropdown w-full max-h-72 !overflow-y-auto">
								    <a href="<?php echo url('dashboard.logs.index') ?>">
									    <?php e__('Show All') ?>
								    </a>
								    <?php foreach ($actions as $actionID => $actionText): ?>
									    <a href="<?php echo url('dashboard.logs.index') ?>?action=<?php echo $actionID; ?>" class="<?php _active(get('action') === $actionID); ?>">
										    <?php echo $actionText ?>
									    </a>
								    <?php endforeach; ?>
							    </div>
						    </div>
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <?php e__('Action') ?>/<?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('IP') ?>
						    </th>
						    <th class="!text-center">
							    <?php e__('Data') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($logs as $log): ?>
						    <tr>
							    <td>
								    <div>
									    <?php e__($actions[$log["action"]] ?? $log["action"]) ?>
								    </div>
								    <div>#<?php echo $log['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $log['accountID']]) ?>" class="text-sm text-gray-500 line-clamp-2 max-w-sm block">
									    <?php echo $log['realname'] ?>
								    </a>
								    <div>@<?php echo $log['username'] ?></div>
							    </td>
							    <td>
								    <?php echo $log['ip'] ?>
							    </td>
							    <td class="not">
								    <div class="flex items-center justify-center">
									    <?php if ($log["data"] == null): ?>
										    <i data-feather="history" class="w-5 h-5 text-gray-500"></i>
									    <?php else: ?>
										    <div x-bind="tooltip('<?php echo htmlentities($log["data"]) ?>')">
											    <i data-feather="history" class="w-5 h-5 text-orange-500 cursor-pointer"></i>
										    </div>
									    <?php endif; ?>
								    </div>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($log['creationDate'], 2, true) ?></div>
								    <div><?php echo convertTime($log['creationDate']) ?></div>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No logs found!'),
            'details' => t__('There are no logs to show you right now.')
        ]);
    endif; ?>
</section>
