<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.lotteries.index',
        'text' => t__('Wheel of Fortune')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Wheel of Fortune'),
    'category' => 'misc.lotteries',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Wheel of Fortune') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/wheel-of-fortune" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.lotteries.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <form action="<?php echo url('dashboard.lotteries.create') ?>" method="post" class="grid gap-4 mt-10">
        <div class="card p-6 grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control">
            </div>

            <div x-data="{priceStatus: '<?php _old('priceStatus', 0) ?>'}">
                <div>
                    <label for="priceStatus" class="form-label">
                        <?php e__('Price Status') ?>
                    </label>
                    <select x-data="select2Alpine()" x-init="changed('priceStatus',() => priceStatus=selected)" name="priceStatus" id="priceStatus">
                        <option value="0" <?php _selected(old('priceStatus') == 0); ?>>
                            <?php e__('Free') ?>
                        </option>
                        <option value="1" <?php _selected(old('priceStatus') == 1); ?>>
                            <?php e__('Paid') ?>
                        </option>
                    </select>
                </div>

                <div x-show="priceStatus === '1'" class="mt-3">
                    <label for="price" class="form-label">
                        <?php e__('Price') ?>
                    </label>
                    <input value="<?php _old('price') ?>" type="text" id="price" name="price" class="form-control">
                </div>
                <div x-show="priceStatus === '0'" class="mt-3">
                    <label for="duration" class="form-label">
                      <?php e__('Re-spin Period') ?>
                      <span class="text-gray-400/75">(<?php e__('Hour') ?>)</span>
                    </label>
                    <input value="<?php _old('duration') ?>" type="text" id="duration" name="duration" class="form-control">
                </div>
            </div>
        </div>
		    <div class="card p-6 grid gap-4">
			    <?php
				    $defaultInputs = array_map(function($lotteryTitle, $lotteryChance, $lotteryColor, $lotteryAwardType, $lotteryAward) {
					    return [
						    'lotteryTitle' => $lotteryTitle,
						    'lotteryChance' => $lotteryChance,
						    'lotteryColor' => $lotteryColor,
						    'lotteryAwardType' => $lotteryAwardType,
						    'lotteryAward' => $lotteryAward,
					    ];
				    }, old('lotteryTitle', []), old('lotteryChance', []), old('lotteryColor', []), old('lotteryAwardType', []), old('lotteryAward', []));
			    ?>
			    <div x-data="inputArray({
                lotteryTitle: '',
                lotteryChance: '',
                lotteryColor: '#000000',
                lotteryAwardType: '1',
                lotteryAward: ''
              }, <?php echo htmlentities(json_encode($defaultInputs)) ?>)"
			         x-init="$nextTick(() => {
                     onDelete = (index) => {
                      inputs.map((input, i) => {
                        if (input.lotteryAwardType === '2') {
                        console.log(input.lotteryAwardType);
                          $('#input_' + i + ' select[name=\'lotteryAward[]\']').val(input.lotteryAward).trigger('change');
                        }
                      })
                   }})"
			    >
				    <div class="flex justify-between items-center">
					    <div class="card-title">
						    <?php e__('Awards') ?>
					    </div>
					    <span @click="addInput()" class="btn btn-sm btn-sheer btn-primary cursor-pointer flex items-center justify-center gap-1">
						    <i data-feather="add" class="w-4 h-4 -ml-1"></i>
						    <?php e__('Add') ?>
					    </span>
				    </div>
				    <table class="mt-3 table">
					    <colgroup>
						    <col style="width: 30%;">
						    <col style="width: 15%;">
						    <col style="width: 15%;">
						    <col style="width: 15%;">
					    </colgroup>
					    <thead class="">
					    <tr class="table-header !text-xs !text-gray-500">
						    <th scope="col" class="!text-left">
							    <?php e__('Title') ?>
						    </th>
						    <th scope="col" class="!text-left">
							    <?php e__('Chance') ?>
						    </th>
						    <th scope="col" class="!text-left">
							    <?php e__('Color') ?>
						    </th>
						    <th scope="col" class="!text-left">
							    <?php e__('Type') ?>
						    </th>
						    <th scope="col" class="!text-left">
							    <?php e__('Award') ?>
						    </th>
						    <th scope="col" style="width: 40px">
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="divide-y divide-gray-200/20 text-center">
					    <template x-for="(input, index) in inputs" :key="index">
						    <tr x-bind:id="'input_' + index">
							    <td class="!text-left !pl-0">
								    <input type="text" class="form-control" name="lotteryTitle[]" x-bind:value="input.lotteryTitle">
							    </td>
							    <td class="!text-left !pl-0">
								    <input type="text" class="form-control" name="lotteryChance[]" placeholder="0.01-100" x-bind:value="input.lotteryChance">
							    </td>
							    <td class="!text-left !pl-0">
								    <div class="coloris-container square">
									    <input type="text" class="form-control coloris coloris-instance" name="lotteryColor[]" x-data="colorPicker()" x-bind:value="input.lotteryColor">
								    </div>
							    </td>
							    <td class="!text-left !pl-0">
								    <select name="lotteryAwardType[]" class="form-control" x-model="input.lotteryAwardType" x-on:change="input.lotteryAward = ''">
									    <option value="1" :selected="input.lotteryAwardType === '1'">
										    <?php e__('Credits') ?>
									    </option>
									    <option value="2" :selected="input.lotteryAwardType === '2'">
										    <?php e__('Product') ?>
									    </option>
									    <option value="3" :selected="input.lotteryAwardType === '3'">
										    <?php e__('Pass') ?>
									    </option>
								    </select>
							    </td>
							    <td class="!text-left !pl-0">
								    <div x-show="input.lotteryAwardType === '1'">
									    <input :disabled="input.lotteryAwardType !== '1'" type="text" class="form-control" name="lotteryAward[]" x-bind:value="input.lotteryAward" placeholder="<?php e__('Amount') ?>">
								    </div>
								    <div x-show="input.lotteryAwardType === '2'">
									    <label class="sr-only">
										    <?php e__('Product') ?>
									    </label>
									    <?php $this->insert('components/select-product', [
										    'name' => 'lotteryAward[]',
										    'placeholder' => t__('Select product'),
										    'selectedJS' => 'input.lotteryAward',
										    'disabledJS' => 'input.lotteryAwardType !== \'2\'',
										    'list' => $productList,
										    'onChange' => '(selected) => { input.lotteryAward = selected }'
									    ]); ?>
								    </div>
								    <div x-show="input.lotteryAwardType === '3'">
									    <?php e__('None') ?>
									    <input :disabled="input.lotteryAwardType !== '3'" type="hidden" name="lotteryAward[]" value="0">
								    </div>
							    </td>
							    <td class="justify-end flex items-center !px-0" style="width: 40px;">
								    <div @click="deleteInput(index)" class="btn btn-sheer btn-danger">
									    <i class="stroke-red-500 stroke-2 w-4" data-feather="trash"></i>
								    </div>
							    </td>
						    </tr>
					    </template>
					    </tbody>
				    </table>
			    </div>
		    </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success">
                <?php e__('Create') ?>
            </button>
        </div>
    </form>
</section>