<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.lotteries.index',
        'text' => t__('Wheel of Fortune')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Wheel of Fortune'),
    'category' => 'misc.lotteries',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($lotteries) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Wheel of Fortune') ?>
            </h1>
            <a href="<?php echo url('dashboard.lotteries.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Wheel of Fortune')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="title">
								    <?php e__('Title') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="respinPeriod">
								    <?php e__('Re-spin Period') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="price">
								    <?php e__('Price') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($lotteries as $lottery): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.lotteries.edit', ['id' => $lottery['id']]) ?>" class="title"><?php echo $lottery['title'] ?></a>
								    <div>#<?php echo $lottery['id'] ?></div>
							    </td>
							    <td class="respinPeriod">
								    <?php echo ($lottery["duration"] != 0) ? t__('%hours% hour(s)', ['%hours%' => $lottery["duration"]]) : '-'; ?>
							    </td>
							    <td class="price center">
								    <?php if ($lottery['price'] > 0): ?>
									    <div><?php echo $lottery['price'] ?></div>
									    <div><?php echo (moduleSettings('credit', 'creditText') != "" && moduleSettings('credit', 'creditText') != null) ? moduleSettings('credit', 'creditText') : t__('Credits') ?></div>
								    <?php else: ?>
									    <?php e__('Free') ?>
								    <?php endif; ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/fortune-wheel/<?php echo $lottery["slug"]; ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.lotteries.edit', ['id' => $lottery['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.lotteries.destroy', ['id' => $lottery['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No wheel of fortune found!'),
            'details' => t__('You can add new wheel of fortune by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.lotteries.create',
                'text' => t__('Create Wheel of Fortune')
            ],
        ]);
    endif; ?>
</section>
