<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.lotteries.index',
        'text' => t__('Wheel of Fortune')
    ],
    [
        'text' => t__('Logs')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Wheel of Fortune Logs'),
    'category' => 'logs.lottery',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($lotteryLogs) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Wheel of Fortune Logs') ?>
            </h1>
        </div>
	    
		    <div class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <form method="get" action="<?php echo url('dashboard.lotteries.logs.index') ?>" class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Wheel of Fortune Logs')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control" name="search" placeholder="<?php e__('Search...') ?>" value="<?php echo $this->e(input("search")) ?>">
					    </div>
				    </form>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th style="width: 40px">
							    <?php e__('ID') ?>
						    </th>
						    <th>
							    <?php e__('User') ?>
						    </th>
						    <th>
							    <?php e__('Wheel of Fortune') ?>
						    </th>
						    <th>
							    <?php e__('Award') ?>
						    </th>
						    <th class="date">
							    <?php e__('Date') ?>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($lotteryLogs as $lotteryLog): ?>
						    <tr>
							    <td>
								    <div>#<?php echo $lotteryLog['id'] ?></div>
							    </td>
							    <td>
								    <a href="<?php echo url('dashboard.accounts.show', ['id' => $lotteryLog['accountID']]) ?>"><?php echo $lotteryLog['realname'] ?></a>
								    <div>@<?php echo $lotteryLog['username'] ?></div>
							    </td>
							    <td class="not">
								    <a href="<?php echo url('dashboard.lotteries.edit', ['id' => $lotteryLog['lotteryID']]) ?>">
									    <?php echo $lotteryLog['lotteryTitle'] ?>
								    </a>
							    </td>
							    <td>
								    <?php echo $lotteryLog["awardTitle"] ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($lotteryLog["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($lotteryLog["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.lotteries.logs.show', ['id' => $lotteryLog['id']]) ?>" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <form action="<?php echo url('dashboard.lotteries.logs.destroy', ['id' => $lotteryLog['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
			    <?php $this->insert('components/pagination', compact('page', 'visiblePageCount', 'pageCount')); ?>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No Wheel of Fortune logs found!'),
            'details' => t__('There are no Wheel of Fortune logs to show you right now.')
        ]);
    endif; ?>
</section>
