<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.lotteries.index',
    'text' => t__('Wheel of Fortune')
  ],
  [
    'url' => 'dashboard.lotteries.logs.index',
    'text' => t__('Logs')
  ],
  [
    'text' => t__('View')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('View'),
  'category' => 'logs.lottery',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Wheel of Fortune Logs') ?>
    </h1>
    <a href="<?php echo url('dashboard.lotteries.logs.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <div class="mt-10 grid grid-cols-1 lg:grid-cols-10 gap-6">
    <div class="col-span-7">
      <div class="card py-4 px-6">
        <table class="table">
          <thead>
          <tr class="table-header">
            <th scope="col" class="text-left">
              <?php e__('Award') ?>
            </th>
          </tr>
          </thead>
          <tbody>
          <tr>
            <td class="!text-left">
              <span class="text-sm text-gray-500">
                <?php echo $lotteryLog['title'] ?>
              </span>
            </td>
          </tr>
          </tbody>
        </table>
      </div>

      <?php if ($commandLogs !== null && count($commandLogs) > 0): ?>
        <?php $this->insert('components/command-logs', [
          'dataType' => 'lottery',
          'dataID' => $lotteryLog["id"],
          'commandLogs' => $commandLogs
        ]); ?>
      <?php endif; ?>
    </div>
    <div class="col-span-7 lg:col-span-3">
      <div class="card">
        <div class="card-title pt-4 px-6"><?php e__('Summary') ?></div>
        <div class="py-4 px-6">
          <div class="bg-gray-50 rounded-xl py-2 px-3 divide-y divide-gray-600/5">
            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
              <span class="text-sm"><?php e__('User') ?>:</span>
	            <div class="text-right">
		            <a href="<?php echo url('dashboard.accounts.show', ['id' => $lotteryLog['accountID']]) ?>" class="block text-sm font-normal text-gray-700">
			            <?php echo $lotteryLog["realname"]; ?>
		            </a>
		            <div class="text-xs font-normal text-gray-500">
			            @<?php echo $lotteryLog["username"]; ?>
		            </div>
	            </div>
            </div>
            <div class="flex justify-between text-gray-700 font-medium gap-6 py-2">
              <span class="text-sm"><?php e__('Date') ?>:</span>
              <span class="text-sm font-normal text-gray-500 text-right">
                      <?php echo convertTime($lotteryLog["creationDate"], 2, true); ?>
                  </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

