<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'url' => 'dashboard.modules.index',
        'text' => t__('Modules')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Modules'),
    'category' => 'settings.modules',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Modules') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/modules" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
		    </div>
    </div>
	<div class="mt-10 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
		<?php foreach ($modules as $module): ?>
			<div class="card flex flex-col gap-3 p-4">
				<div class="flex justify-between">
					<h5 class="text-gray-800"><?php e__($module['name']) ?></h5>
					
					<?php $this->insert('components/toggle', [
						'name' => 'module_' . $module['id'],
						'default' => $module['isEnabled'],
						'action' => 'await toggleModule(' . $module['id'] . ')'
					]); ?>
				</div>
				<div class="mt-2 grow text-sm text-gray-500">
					<?php e__($module['description']) ?>
				</div>
				<?php if ($module['settingsUrl'] !== null): ?>
                    <div class="mt-2">
                        <a href="<?php echo $module['settingsUrl']; ?>" class="btn btn-outline">
                            <?php e__('Settings') ?>
                        </a>
                    </div>
				<?php endif; ?>
			</div>
		<?php endforeach; ?>
	</div>
</section>