<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.notifications.index',
        'text' => t__('Notifications')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Notifications'),
    'category' => 'dashboard',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container !max-w-6xl">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Notifications') ?></h1>
    </div>

    <div class="mt-10 flex flex-col gap-6 divide-y divide-gray-600/10 card py-4 px-5">
        <?php if (count($notifications) > 0): ?>
            <?php foreach ($notifications as $notification): ?>
                <div class="flex flex-col md:flex-row gap-6 py-4 relative">
                    <div class="w-16 h-16 center relative pl-6">
                        <div class="absolute left-0 inset-y-2 w-0.5 bg-gray-400/50 rounded-r-full"></div>
	                    
		                    <?php $this->insert('components/avatar', [
			                    'avatar' => $notification['avatar'],
			                    'username' => $notification['realname'],
			                    'class' => 'w-10',
			                    'size' => '32px'
		                    ]); ?>
                        <svg class="hidden w-10 stroke-gray-600 dark:stroke-gray-400/50" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.5 10.5H15.5" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M2 11.5599V13.4299C2 16.4299 4 18.4299 7 18.4299H11L15.45 21.39C16.11 21.83 17 21.3599 17 20.5599V18.4299C20 18.4299 22 16.4299 22 13.4299V7.42993C22 4.42993 20 2.42993 17 2.42993H7C4 2.42993 2 4.42993 2 7.42993" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="grow text-sm">
                        <div class="md:pt-3">
                            <div class="flex items-center gap-3 text-gray-400 text-xs font-normal">
                                <span><?php echo convertTime($notification["creationDate"]); ?></span>
                            </div>
                            <div class="mt-1 text-gray-500 text-base">
                                <a href="#" class="text-gray-800 font-medium"><?php echo $notification['realname'] ?></a>
                                <?php if ($notification["type"] == 1): ?>
                                    <?php e__('has sent support message!') ?>
                                <?php elseif ($notification["type"] == 2): ?>
                                    <?php e__('has commented on a news!') ?>
                                <?php elseif ($notification["type"] == 3): ?>
                                    <?php e__('has bought %credit% credits!', ['%credit%' => $notification["variables"]]); ?>
                                <?php elseif ($notification["type"] == 4): ?>
                                    <?php $notification["variables"] = explode(",", $notification["variables"]); ?>
                                    <?php e__('has bought %product% from the %server%', ['%product%' => $notification["variables"][1], '%server%' => $notification["variables"][0]]) ?>
                                <?php else: ?>
                                    <?php e__('ERROR!') ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <?php
            $this->insert('components/empty', [
                'title' => t__('No notifications found!'),
                'details' => t__('You have no notifications yet!'),
            ]);
            ?>
        <?php endif; ?>
    </div>
</section>