<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.pages.index',
        'text' => t__('Pages')
    ],
    [
        'url' => 'dashboard.pages.create',
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Page'),
    'category' => 'content-management.other.pages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Page') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/custom-pages" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.pages.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form method="post" action="<?php echo url('dashboard.pages.store') ?>" class="grid gap-4">
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title') ?>" type="text" id="title" name="title" class="form-control" required>
            </div>
            <div>
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control"
                              data-toggle="textEditor" name="content" id="content"
                    ><?php _old('content') ?></textarea>
                </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>
