<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.pages.index',
        'text' => t__('Pages')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $page['title']]),
    'category' => 'content-management.other.pages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $page['title']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/custom-pages" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.pages.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form method="post" action="<?php echo url('dashboard.pages.update', ['id' => $page['id']]) ?>" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Title') ?>
                </label>
                <input value="<?php _old('title', $page['title']) ?>" type="text" id="title" name="title" class="form-control" required>
            </div>
            <div>
              <label for="slug" class="form-label">
                <?php e__('URL') ?>
              </label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <div class="input-group-text">
                    <?php echo settings('websiteURL') ?>/
                  </div>
                </div>
                <input value="<?php _old('slug', $page['slug']) ?>" type="text" id="slug" name="slug" class="form-control" required>
              </div>
            </div>
            <div x-data="textEditor()">
                <label for="content" class="form-label">
                    <?php e__('Content') ?>
                </label>
                <div x-data="textEditor()" class="mt-2">
                    <textarea x-ref="textEditor" class="form-control"
                              data-toggle="textEditor" name="content" id="content"
                    ><?php _old('content', $page['content']) ?></textarea>
                </div>
            </div>

            <div>
              <?php $this->insert('components/toggle', [
                'name' => 'isActive',
                'default' => old('isActive', $page['isActive']),
                'labelRight' => t__('Is active?')
              ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>
