<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.pages.index',
        'text' => t__('Pages')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Pages'),
    'category' => 'content-management.other.pages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($pages) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Pages') ?>
            </h1>
            <a href="<?php echo url('dashboard.pages.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Pages')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="title">
								    <?php e__('Title') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="url">
								    <?php e__('URL') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="status">
								    <?php e__('Status') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort center" data-sort="date">
								    <?php e__('Date') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($pages as $page): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.pages.edit', ['id' => $page['id']]) ?>" class="title"><?php echo $page['title'] ?></a>
								    <div>#<?php echo $page['id'] ?></div>
							    </td>
							    <td class="url">
								    /<?php echo $page['slug'] ?>
							    </td>
							    <td class="status not">
								    <?php if ($page["isActive"] == 0): ?>
									    <span class="badge badge-soft-danger"><?php e__('Disabled') ?></span>
								    <?php else: ?>
									    <span class="badge badge-soft-success"><?php e__('Active') ?></span>
								    <?php endif; ?>
							    </td>
							    <td class="date">
								    <div><?php echo convertTime($page["creationDate"], 2, true) ?></div>
								    <div><?php echo convertTime($page["creationDate"]) ?></div>
							    </td>
							    <td class="table-action-buttons">
								    <a href="/<?php echo $page['slug'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.pages.edit', ['id' => $page['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.pages.destroy', ['id' => $page['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No pages found!'),
            'details' => t__('You can create a new page by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.pages.create',
                'text' => t__('Create Page')
            ]
        ]);
    endif; ?>
</section>
