<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.payment-gateways.index',
			'text' => t__('Payment Methods')
		],
		[
			'text' => t__('Edit')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('Editing %text%', ['%text%' => $paymentGateway['name']]),
		'category' => 'settings.payment-gateways',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="py-9 los-container tight-container">
	<div class="los-page-heading">
		<h1 class="text-gray-950">
			<?php e__('Editing %text%', ['%text%' => $paymentGateway['name']]) ?>
		</h1>
		<a href="<?php echo url('dashboard.payment-gateways.index') ?>" class="btn btn-default">
			<?php e__('Back') ?>
		</a>
	</div>
	
	<?php _message(); ?>
	
	<form
			method="post"
			action="<?php echo url('dashboard.payment-gateways.update', ['id' => $paymentGateway['slug']]) ?>"
			x-data="{status: '<?php _old('status', $paymentGateway["status"]) ?>', feeStatus: '<?php _old('feeStatus', $paymentGateway["feeStatus"]) ?>'}"
	>
		<?php _method('PATCH'); ?>
		<div class="mt-10 card p-6 grid gap-4">
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'status',
					'default' => old('status', $paymentGateway["status"]),
					'action' => 'status = status === \'1\' ? \'0\' : \'1\'',
					'labelTop' => t__('Is active?')
				]); ?>
			</div>
			<div>
				<label for="name" class="form-label">
					<?php e__('Payment Method') ?>
				</label>
				<input type="text" class="form-control opacity-75" disabled value="<?php echo $paymentGateway['name'] ?>">
			</div>
			<div>
				<label for="title" class="form-label">
					<?php e__('Title') ?>
				</label>
				<input value="<?php _old('title', $paymentGateway['title']) ?>" type="text" name="title" id="title" class="form-control">
			</div>
			<div>
				<label for="currency" class="form-label"><?php e__('Currency') ?></label>
				<div>
					<select x-data="select2Alpine(true)" name="currency" id="currency">
						<option value="" <?php _selected(old('currency', $paymentGateway["currency"]) == null); ?>>
							<?php echo t__('Default Currency') . " (" . settings("currency") . ")" ?>
						</option>
						<?php foreach ($currencies as $currency): ?>
							<option
								value="<?php echo $currency["code"] ?>" <?php _selected(old('currency', $paymentGateway["currency"]) == $currency["code"]); ?>>
								<?php echo $currency["code"] ?>
							</option>
						<?php endforeach; ?>
					</select>
				</div>
			</div>
			<div>
				<label for="order" class="form-label">
					<?php e__('Order') ?>
				</label>
				<input value="<?php _old('order', $paymentGateway['order']) ?>" type="number" name="order" id="order" class="form-control">
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'feeStatus',
					'default' => old('feeStatus', $paymentGateway["feeStatus"]),
					'action' => 'feeStatus = feeStatus === \'1\' ? \'0\' : \'1\'',
					'labelRight' => t__('Charge fee to customer')
				]); ?>
			</div>
			<div x-show="feeStatus === '1'">
				<div class="grid gap-4 grid-cols-1 lg:grid-cols-2">
					<div>
						<label for="transactionFee" class="form-label">
							<?php e__('Transaction Fee') ?> (%)
						</label>
						<div class="input-absolute-group-right">
							<div class="text-gray-500 text-sm">
								%
							</div>
							<input value="<?php _old('transactionFee', $paymentGateway["transactionFee"]) ?>" name="transactionFee" type="text" id="transactionFee" class="form-control">
						</div>
					</div>
					<div>
						<label for="fixedFee" class="form-label">
							<?php e__('Fixed Processing Fee') ?>
						</label>
						<div class="input-absolute-group-right">
							<div class="text-gray-500 text-sm">
								<?php echo settings('currency') ?>
							</div>
							<input value="<?php _old('fixedFee', $paymentGateway["fixedFee"]) ?>" type="text" id="fixedFee" name="fixedFee" class="form-control">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div x-show="status === '1'">
			<div class="mt-8">
				<div class="alert alert-info">
					<div>
						<span class="font-medium">Callback URL:</span>
						<div>
							<?php echo ("https://".$_SERVER["SERVER_NAME"]) . '/callback/' . $paymentGateway["slug"];?>
						</div>
					</div>
				</div>
			</div>
			<div class="card p-6 grid gap-4 mt-8">
				<?php foreach ($paymentGateway["config"] as $config): ?>
					<?php if ($config["settings"]["value_type"] == "text"): ?>
						<div>
							<label for="config__<?php echo $config["key"] ?>" class="form-label"><?php echo $config["settings"]["title"] ?>:</label>
							<div>
								<input type="text" id="config__<?php echo $config["key"] ?>" class="form-control" name="config__<?php echo $config["key"] ?>" value="<?php _old($config["key"], $config["value"]) ?>">
							</div>
						</div>
					<?php endif; ?>
					
					<?php if ($config["settings"]["value_type"] == "select"): ?>
						<div>
							<label for="config__<?php echo $config["key"] ?>" class="form-label"><?php echo $config["settings"]["title"] ?>:</label>
							<select x-data="select2Alpine()" name="config__<?php echo $config["key"] ?>" id="config__<?php echo $config["key"] ?>">
								<?php foreach ($config["settings"]["values"] as $selectableValue): ?>
									<option
										value="<?php echo $selectableValue["value"] ?>" <?php _selected(old($config["key"], $config["value"]) == $selectableValue["value"]); ?>>
										<?php echo $selectableValue["text"] ?>
									</option>
								<?php endforeach; ?>
							</select>
						</div>
					<?php endif; ?>
					
					<?php if ($config["settings"]["value_type"] == "switch"): ?>
						<div>
							<label for="config__<?php echo $config["key"] ?>" class="form-label"><?php echo $config["settings"]["title"] ?>:</label>
							<div>
								<?php $this->insert('components/toggle', [
									'name' => "config__" . $config["key"],
									'default' => old($config["key"], $config["value"]),
									'labelRight' => $config["settings"]["title"],
								]); ?>
							</div>
						</div>
					<?php endif; ?>
					
					<?php if ($config["settings"]["value_type"] == "html"): ?>
						<div>
							<label for="config__<?php echo $config["key"] ?>" class="form-label"><?php echo $config["settings"]["title"] ?>:</label>
							<div x-data="textEditor()" class="mt-2">
								<textarea x-ref="textEditor" class="form-control" data-toggle="textEditor" name="config__<?php echo $config["key"] ?>" id="config__<?php echo $config["key"] ?>"><?php _old($config["key"], $config["value"]) ?></textarea>
							</div>
						</div>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>
		</div>
		<div class="flex justify-end mt-6">
			<?php _csrf(); ?>
			<button type="submit" class="btn btn-success">
				<?php e__('Save Changes') ?>
			</button>
		</div>
	</form>
</section>
