<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.payment-gateways.index',
        'text' => t__('Payment Methods')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Payment Methods'),
    'category' => 'settings.payment-gateways',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Payment Methods') ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/payment-methods/index" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
		    </div>
    </div>
	
		<div x-data="listjs()" id="listjs" class="grid mt-10">
			<div class="los-table-actions mb-4 grid">
				<div class="w-full">
					<label for="search" class="form-label">
						<?php e__('Search for %text%', ['%text%' => t__('Payment Methods')]) ?>
					</label>
					<div class="input-absolute-group">
						<i data-feather="search-normal"></i>
						<input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					</div>
				</div>
			</div>
			<div class="los-table">
				<table>
					<thead>
					<tr>
						<th>
							<div class="sort" data-sort="paymentGateway">
								<?php e__('Payment Method') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="title">
								<?php e__('Title') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="status">
								<?php e__('Status') ?>
							</div>
						</th>
						<th>
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody class="list">
					<?php foreach ($paymentGateways as $paymentGateway): ?>
						<tr>
							<td class="not">
								<a href="<?php echo url('dashboard.payment-gateways.edit', ['id' => $paymentGateway['slug']]) ?>" class="paymentGateway">
									<?php echo $paymentGateway['name'] ?>
								</a>
							</td>
							<td class="title">
								<?php echo $paymentGateway['title'] ?>
							</td>
							<td class="status not">
								<?php if ($paymentGateway["status"] == 0): ?>
									<span class="badge badge-soft-danger"><?php e__('Disabled') ?></span>
								<?php else: ?>
									<span class="badge badge-soft-success"><?php e__('Active') ?></span>
								<?php endif; ?>
							</td>
							<td class="table-action-buttons">
								<a href="<?php echo url('dashboard.payment-gateways.edit', ['id' => $paymentGateway['slug']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									<i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								</a>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
</section>

