<?php
$breadcrumbs = [
    [
        'text' => t__('Popup')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => "Popup"]),
    'category' => 'misc.popup',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => "Popup"]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/popup" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form class="grid gap-4" action="<?php echo url('dashboard.popup.update') ?>" method="post" enctype="multipart/form-data">
            <?php _method('PATCH') ?>
            <div>
                <label for="link" class="form-label">
                    <?php e__('Link') ?>
                </label>
                <input value="<?php _old('link', moduleSettings('popup', 'link')) ?>" type="text" name="link" id="link" class="form-control">
            </div>

            <div x-data="image">
                <label for="picture" class="form-label">
                    <?php e__('Image') ?>
                </label>
                <div class="mt-2 image-group" x-bind="imageContainer">
                    <img x-show="imagePreview === null" src="<?php echo '/assets/core/images/uploads/' . moduleSettings('popup', 'image') ?>" alt="">
                    <img x-show="imagePreview !== null" :src="imagePreview" alt="">
                    <span>
                      <?php e__('Select an image') ?>
                    </span>
                    <input name="image" x-bind="imageInput" type="file" accept="image/*" class="opacity-0">
                </div>
            </div>


            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>