<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.redirects.index',
        'text' => t__('URL Redirects')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $redirect['from']]),
    'category' => 'misc.redirects',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $redirect['from']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/url-redirects" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.redirects.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form method="post" action="<?php echo url('dashboard.redirects.update', ['id' => $redirect['id']]) ?>" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div>
                <label for="title" class="form-label">
                    <?php e__('Redirect From') ?>
                </label>
                <input value="<?php _old('from', $redirect['from']) ?>" type="text" id="from" name="from" class="form-control" placeholder="<?php e__('e.g. /discord') ?>" required>
            </div>
	        
		        <div>
			        <label for="title" class="form-label">
				        <?php e__('Redirect To') ?>
			        </label>
			        <input value="<?php _old('to', $redirect['to']) ?>" type="text" id="to" name="to" class="form-control" placeholder="<?php e__('Enter a link') ?>" required>
		        </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>
