<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.redirects.index',
        'text' => t__('URL Redirects')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('URL Redirects'),
    'category' => 'misc.redirects',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($redirects) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('URL Redirects') ?>
            </h1>
            <a href="<?php echo url('dashboard.redirects.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('URL Redirects')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="redirectFrom">
								    <?php e__('Redirect From') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="redirectTo">
								    <?php e__('Redirect To') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($redirects as $redirect): ?>
						    <tr>
							    <td class="redirectFrom">
								    <?php echo $redirect['from'] ?>
							    </td>
							    <td class="redirectTo">
								    <?php echo $redirect['to'] ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo $redirect['from'] ?>" target="_blank" x-bind="tooltip('<?php e__('View') ?>')" class="btn btn-sm btn-icon btn-primary">
									    <i class="stroke-white stroke-2 w-4" data-feather="eye"></i>
								    </a>
								    <a href="<?php echo url('dashboard.redirects.edit', ['id' => $redirect['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.redirects.destroy', ['id' => $redirect['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No URL redirects found!'),
            'details' => t__('You can create a new redirect by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.redirects.create',
                'text' => t__('Create URL Redirect')
            ]
        ]);
    endif; ?>
</section>
