<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.roles.index',
        'text' => t__('Roles')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $role['name']]),
    'category' => 'user-management.roles',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('styles') ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/theme/material-ocean.min.css"/>
<style>
    .CodeMirror-gutter .CodeMirror-linenumbers {
        width: 29px !important
    }

    .CodeMirror-gutter-wrapper {
        left: -30px !important
    }

    .CodeMirror-sizer {
        margin-left: 30px !important;
        margin-bottom: -16px !important;
        border-right-width: 14px !important;
        min-height: 160px !important;
        min-width: 78.5px !important;
        padding-right: 0px !important;
        padding-bottom: 0px !important;
    }
</style>
<?php $this->end();
$this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/css/css.min.js"></script>
<?php $this->end() ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $role['name']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/roles" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
		      <a href="<?php echo url('dashboard.roles.index') ?>" class="btn btn-default">
		          <?php e__('Back') ?>
		      </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.roles.update', ['id' => $role['id']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH'); ?>
		        <div>
			        <label for="slug" class="form-label">
				        <?php e__('ID') ?>
			        </label>
			        <input value="<?php echo $role['slug'] ?>" type="text" id="slug" class="form-control" readonly>
		        </div>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name', $role['name']) ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div>
                <label for="priority" class="form-label">
                    <?php e__('Priority') ?>
                </label>
                <input value="<?php _old('priority', $role['priority']) ?>" type="number" id="priority" name="priority" class="form-control">
            </div>
            <?php if (!moduleIsDisabled('discord') || \Dashboard\Services\DiscordBotService::isBotReady()): ?>
              <div>
                <label for="discordRoleID" class="form-label">
                  <?php e__('Discord Role ID') ?>
                </label>
                <input value="<?php _old('discordRoleID', $role["discordRoleID"]) ?>" type="text" id="discordRoleID" name="discordRoleID" class="form-control">
              </div>
            <?php endif; ?>
            <div x-data="codeMirror()">
                <label for="usernameCSS" class="form-label">
                    <?php e__('Username CSS') ?>
                </label>
                <textarea x-ref="editor" id="usernameCSS" class="form-control"
                          name="usernameCSS"><?php _old('usernameCSS', $role['usernameCSS']) ?></textarea>
            </div>
            <div x-data="codeMirror()">
                <label for="badgeCSS" class="form-label">
                    <?php e__('Badge CSS') ?>
                </label>
                <textarea x-ref="editor" id="badgeCSS" class="form-control"
                          name="badgeCSS"><?php _old('badgeCSS', $role['badgeCSS']) ?></textarea>
            </div>
            <div x-data="{ isStaffRole: <?php echo old('isStaffRole', $isStaffRole) ? 'true' : 'false' ?> }">
                <div>
                    <label for="" class="form-label">
                        <?php e__('Is staff role?') ?>
                    </label>
                    <?php $this->insert('components/toggle', [
                      'name' => 'isStaffRole',
                      'default' => old('isStaffRole', $isStaffRole),
                      'action' => 'isStaffRole = !isStaffRole'
                    ]); ?>
                </div>
                <div x-show="isStaffRole" class="mt-4 grid xl:grid-cols-4 gap-3">
                    <?php foreach ($permissions as $permission): ?>
                      <?php if ($permission["name"] == "VIEW_DASHBOARD")
                        continue;
                      ?>
                      <div class="flex gap-2.5 items-center">
                        <input
                          type="checkbox"
                          name="permissions[]"
                          class="form-checkbox"
                          id="permission_<?php echo $permission["id"] ?>"
                          value="<?php echo $permission["id"] ?>"
                          <?php _checked(in_array($permission["id"], old('permissions', $rolePermissionList)) && old('isStaffRole', $isStaffRole)); ?>
                        >
                        <label class="form-label !mb-0" for="permission_<?php echo $permission["id"] ?>">
                          <?php e__($permission["description"]) ?>
                        </label>
                      </div>
                    <?php endforeach; ?>
                </div>
            </div>


            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

