<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.roles.index',
        'text' => t__('Roles')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Roles'),
    'category' => 'user-management.roles',
    'breadcrumbs' => $breadcrumbs
]) ?>


<section class="los-container py-9">
    <?php if (count($roles) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Roles') ?>
            </h1>
            <a href="<?php echo url('dashboard.roles.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>

        <?php _message(); ?>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Roles')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="name">
								    <?php e__('Name') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="priority">
								    <?php e__('Priority') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($roles as $role): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.roles.edit', ['id' => $role['id']])?>" class="name"><?php echo $role['name'] ?></a>
								    <div><?php echo $role['slug'] ?></div>
							    </td>
							    <td class="priority">
								    <?php echo $role['priority'] ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.roles.edit', ['id' => $role['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.roles.destroy', ['id' => $role['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No role found!'),
            'details' => t__('You can create a new role by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.roles.create',
                'text' => t__('Create Role')
            ],
        ]);
    endif; ?>

</section>
