<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.servers.index',
        'text' => t__('Servers')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Create Server'),
    'category' => 'store.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Create Server') ?></h1>
	      <div class="flex gap-2">
		      <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/store/game-servers" class="btn btn-dark" target="_blank">
			      <?php e__('Help') ?>
		      </a>
	        <a href="<?php echo url('dashboard.servers.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
	      </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.servers.create') ?>" method="post" class="grid gap-4" data-submit-loading>
            <div>
                <label for="name" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('name') ?>" type="text" id="name" name="name" class="form-control">
            </div>
            <div>
                <label for="ip" class="form-label">
                    <?php e__('Server IP') ?>
                </label>
                <input value="<?php _old('ip') ?>" type="text" id="ip" name="ip" class="form-control">
            </div>
            <div>
                <label for="port" class="form-label">
                    <?php e__('Server Port') ?>
                </label>
                <input value="<?php _old('port') ?>" type="number" id="port" name="port" class="form-control">
            </div>
            <div class="grid gap-4" x-data="{consoleID: '<?php _old('consoleID', (in_array(settings('gameType'), $leaderosConnectSupportedGames)) ? 4 : 2); ?>'}">
              <div>
                <label for="consoleID" class="form-label">
                  <?php e__('Console Type') ?>
                </label>
	              <?php $this->insert('components/select-console-type', [
		              'leaderosConnectSupportedGames' => $leaderosConnectSupportedGames
	              ]); ?>
              </div>
              <div x-show="consoleID !== '4'">
                <label for="consolePort" class="form-label">
                  <?php e__('Console Port') ?>
                </label>
                <input value="<?php _old('consolePort') ?>" type="number" id="consolePort" name="consolePort" class="form-control">
              </div>
              <div x-show="consoleID !== '4'">
                <label for="consolePassword" class="form-label">
                  <?php e__('Console Password') ?>
                </label>
                <input value="<?php _old('consolePassword') ?>" type="password" id="consolePassword" name="consolePassword" class="form-control">
              </div>
              <div x-show="consoleID !== '4'">
                <button type="button" @click="checkConsole()" class="btn btn-default flex items-center ring-0">
                  <svg style="display: none;" class="animate-spin -ml-1 mr-3 h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                  </svg>
                  <span>
                    <?php e__('Check Console Connection') ?>
                  </span>
                </button>
              </div>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Create') ?>
                </button>
            </div>
        </form>
    </div>
</section>

