<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.servers.index',
        'text' => t__('Servers')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Servers'),
    'category' => 'store.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <?php if (count($servers) > 0): ?>
        <div class="los-page-heading">
            <h1 class="text-gray-950">
                <?php e__('Servers') ?>
            </h1>
            <a href="<?php echo url('dashboard.servers.create') ?>" class="btn btn-primary">
                <?php e__('Add New') ?>
            </a>
        </div>
	    
		    <div x-data="listjs()" id="listjs" class="grid mt-10">
			    <div class="los-table-actions mb-4 grid">
				    <div class="w-full">
					    <label for="search" class="form-label">
						    <?php e__('Search for %text%', ['%text%' => t__('Servers')]) ?>
					    </label>
					    <div class="input-absolute-group">
						    <i data-feather="search-normal"></i>
						    <input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					    </div>
				    </div>
			    </div>
			    <div class="los-table">
				    <table>
					    <thead>
					    <tr>
						    <th>
							    <div class="sort" data-sort="server">
								    <?php e__('Server') ?>/<?php e__('ID') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="ip">
								    <?php e__('IP') ?>
							    </div>
						    </th>
						    <th>
							    <div class="sort" data-sort="consoleType">
								    <?php e__('Console Type') ?>
							    </div>
						    </th>
						    <th>
							    <span class="sr-only">
								    <?php e__('Actions') ?>
							    </span>
						    </th>
					    </tr>
					    </thead>
					    <tbody class="list">
					    <?php foreach ($servers as $server): ?>
						    <tr>
							    <td>
								    <a href="<?php echo url('dashboard.servers.edit', ['id' => $server['id']]) ?>" class="server"><?php echo $server['name'] ?></a>
								    <div>#<?php echo $server['id'] ?></div>
							    </td>
							    <td class="ip">
								    <?php echo $server['ip'] ?>
							    </td>
							    <td class="consoleType">
								    <?php
									    switch ($server["consoleID"]) {
										    case 1:
											    echo 'Websend';
											    break;
										    case 2:
											    echo 'RCON';
											    break;
										    case 3:
											    echo 'Websender';
											    break;
										    case 4:
											    echo 'LeaderOS Connect';
											    break;
										    default:
											    echo t__('Error!');
											    break;
									    }
								    ?>
							    </td>
							    <td class="table-action-buttons">
								    <a href="<?php echo url('dashboard.servers.edit', ['id' => $server['id']]) ?>" x-bind="tooltip('<?php e__('Edit') ?>')" class="btn btn-sm btn-icon btn-success">
									    <i class="stroke-white stroke-2 w-4" data-feather="edit"></i>
								    </a>
								    <form action="<?php echo url('dashboard.servers.destroy', ['id' => $server['id']]) ?>" method="post" x-data="deleteConfirmation()">
									    <?php _method('DELETE'); ?>
									    <?php _csrf(); ?>
									    <button x-bind="tooltip('<?php e__('Delete') ?>')" type="submit" class="btn btn-sm btn-icon btn-danger">
										    <i class="stroke-white stroke-2 w-4" data-feather="trash"></i>
									    </button>
								    </form>
							    </td>
						    </tr>
					    <?php endforeach; ?>
					    </tbody>
				    </table>
			    </div>
		    </div>
    <?php else:
        $this->insert('components/empty', [
            'title' => t__('No servers found!'),
            'details' => t__('You can add servers by clicking the button below.'),
            'button' => [
                'url' => 'dashboard.servers.create',
                'text' => t__('Create Server')
            ],
        ]);
    endif; ?>
</section>
