<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.servers.index',
        'text' => t__('Servers')
    ],
		[
			'url' => url('dashboard.servers.edit', ['id' => $server["id"]]),
			'text' => $server["name"]
		],
    [
      'text' => t__('Plugin')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Plugin'),
    'category' => 'store.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
<script>
    var clipboard = new ClipboardJS('.copyConfig');
    clipboard.on('success', function(e) {
        e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'none';
        e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'block';
        setTimeout(function() {
            e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'block';
            e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'none';
        }, 2000);
    });
</script>
<?php $this->end(); ?>

<section class="los-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Plugin') ?>
    </h1>
  </div>
  <div class="card p-6 mt-10 grid gap-5">
    <div>
      <p class="text-gray-800 font-medium mb-2">1. <?php e__('Download LeaderOS Script') ?></p>
      <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <a href="https://www.leaderos.net/plugin/fivem" class="plugin-card" target="_blank">
          <div>
            <img width="60px" src="data:image/png;base64,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" alt="FiveM" />
          </div>
          <div class="flex flex-col justify-center">
            <span class="plugin-platform">LeaderOS Connect</span>
            <span class="plugin-platform-alternatives">
	            <?php e__('Click to Download') ?>
            </span>
          </div>
        </a>
      </div>
    </div>
    <div>
      <p class="text-gray-800 font-medium mb-2">2. <?php e__('Configure the script') ?></p>
      <div class="plugin-config">
        <div class="absolute top-3 right-3" x-bind="tooltip('<?php e__('Copy') ?>')">
          <div data-clipboard-text='global.config = {
    websiteUrl: "<?php echo ("https://".$_SERVER["SERVER_NAME"]); ?>",
    apiKey: "<?php echo settings('apiKey') ?>",
    serverToken: "<?php echo $server["consoleToken"] ?>",
    checkPlayerOnline: true,
    lang: "tr",' class="copyConfig cursor-pointer w-8 h-8 flex items-center justify-center bg-gray-500/10 hover:bg-gray-500/30 border border-gray-200 dark:border-gray-600/20 rounded-lg">
            <i data-feather="copy" class="w-4 text-gray-800 copy-icon"></i>
            <i data-feather="tick-circle" class="w-4 text-success copied-icon" style="display: none;"></i>
          </div>
        </div>
        <div class="text-gray-300 font-medium mb-3 select-none">config.js</div>
        <div><span class="text-red-400 font-medium">global.config <span class="text-gray-300">=</span> </span><span class="text-white">{</span></div>
        <div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">websiteUrl</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">"<?php echo ("https://".$_SERVER["SERVER_NAME"]); ?>",</span></div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">apiKey</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">
              "<?php echo settings('apiKey') ?>",
            </span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">serverToken</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">
              "<?php echo $server["consoleToken"] ?>",
            </span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">checkPlayerOnline</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">true,</span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">lang</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">"<?php echo $lang == "tr" ? "tr" : "en"; ?>",</span></div>
        </div>
      </div>
    </div>
  </div>
</section>
