<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.servers.index',
        'text' => t__('Servers')
    ],
		[
			'url' => url('dashboard.servers.edit', ['id' => $server["id"]]),
			'text' => $server["name"]
		],
    [
      'text' => t__('Plugin')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Plugin'),
    'category' => 'store.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
<script>
    var clipboard = new ClipboardJS('.copyConfig');
    clipboard.on('success', function(e) {
        e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'none';
        e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'block';
        setTimeout(function() {
            e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'block';
            e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'none';
        }, 2000);
    });
</script>
<?php $this->end(); ?>

<section class="los-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Plugin') ?>
    </h1>
  </div>
  <div class="card p-6 mt-10 grid gap-5">
    <div>
      <p class="text-gray-800 font-medium mb-2">1. <?php e__('Download LeaderOS Plugin') ?></p>
      <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <a href="<?php echo leaderosWebsiteUrl() ?>/plugin/bukkit" class="plugin-card" target="_blank">
          <div>
            <img width="60px" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAAEsCAMAAABOo35HAAACo1BMVEVHcEzjjD+oqKhycnKWlpbY2Ng1NTX///////9RUVH////k0lzn5+fKysriz1rLRie/ln7MRiiromurgmvFQCHDPh+VjFWpqamVbFWje2PYUzS/tn7qk0bchjjq12LpkkXf39/b29vg4ODa2trc3NzX19fm5ubZ2dnOzs7e3t7V1dWnp6f36efW1tbMzMzQ0NDz8/PNzc335+W0tLTy8vLLy8vd3d3Pz8/l5eXx8fH35uTBwcHk5OS+vr7T09PS0tKxsbH46uidnZ346+rx19Py2db57evo6OjgnZPz29fh4eHy2NTR0dG/v7/57ezU1NTs7Ozel4zq6urp6env7+/w8PC7u7vi4uKvr6+wsLD14t/r6+vu7u61tbVUVFT46+mfn59+fn6urq736Ob24+F0dHTj4+P25eL14d7t7e3039xNTU2rq6tsbGz77+f25uPz3Nj57uz88+1lZWVubm7z3dpfX19VVVVvb2/Jyclqamr77eRSUlJMTExaWlry2dX47Or88er88uv66N1QUFD77uZbW1tOTk6srKz66t/66d704N1jY2P66NxeXl766+Cmpqbz29j25eP88OnFxcXuq3j03dqzs7OlpaX76+JdXV1mZmZWVlatra1CQkJoaGjXfGz55tnCwsI/Pz/urHn03ttwcHBhYWH55djWemqkpKTurn6ysrLur366urr659tXV1furHr77OP659rXfW777eP77OJBQUHXfG1paWlcXFzurXz65tpiYmL14N5zc3NnZ2dERERxcXH55Nfurn1AQEDurXtZWVn55df14+Dy19T88Oj25OHy2tb88uz88+7tq3f77uXXfm/76+FgYGBtbW3tqnZHR0dkZGRTU1NLS0vXe2tFRUVra2vWeWnkqqHz3NmfCSwuAAAACXRSTlMA////////aXfzer1aAAAGgUlEQVR42uzYzUtUURiAcSf1gjalZt+fpuQMphOjRFKiDGaSWtEmQYiCJMWFmeDKhR/RoiLCSqWdgoImJpqGYLhRpAz7hDZB9ac048xA5nmv99C4cM7zLIe7+vG+5945CbHOikkpMSgh5oEFFlhggQUWWGCBBRZYYIEFFlhggQUWWGCBBRZYYIEFlrlYllYHhDKV7dIqUyhdmR4tWGCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhggQXW1sKSWfYK7Ve2R8ilbLtWLqEMZelCh5RZQmCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhggQUWWGCBZRpWijJL6IiynVq5hPQQDyvLELKUgQUWWGCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhgxQuWW8jSSo21W8illaXVPmVggQUWWGCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhggQWWHVaykFsraxM7qixNKFEZWGCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhggQVWPGPJpQodVLYjJh1TliQEFlhggQUWWGCBBRZYYIEFFlhggQUWWGCBBVZcYp0KVxOpLJxX8eT3z729vUNDQ5OTS0tzc4uLY2Nj4+PjL22xbkaLD6ysrOzsqqqq2trbt0tKiotzc3Pd7spKj+LJhcHBicf3Hj548m2q/cv95uZnXd0fWz89t8VKjRanWG4J693I29erWC+mZtrDWN2trYZhZTnEWhgZjGC9aQ9ifTAJS15DebImIlgzYayuTV5DmVBID0v99DabTvv8Xu+Z4AlfVlp6Ja+g4ERysifn+DnFk+c7Knpa2oab5hvf1zc8PVuYHwh0XrhclGj33kuNtgHKlsHyea+t+UXCWq6u6Lma9nc3yu2wop2MJyy/AkuYrIvrsO4ajuWRsKrXY3WaMlnyGspYxq+hz+8UizV0vIbLHSsc8Bzw/zNZnFl2WK8cYq38gxUo72QNnU5WwLw19PkdrmEHa6j6dMhxOFmcWR4Zqwes9W/DHM6smP/dCV3RGId1qb+/vyjU9VB2WL9+jo6O/hgYGJidnZ7+asAaKi//asKXf3nByz+PDVbL776mR3V19Q13Qpd/hmMVbITV1tc0v4pVGMQy6qNUvlaWsYajk3XLzMnyr8XybITVGJmsfBP/SPt1JqsvirVVziw5iVAHMUmrRAlrbWCBBRZYYIEFFlhggQUWWGCBBRZYYIEFFlhggfWnvbt7iSIKwwAutH1sGP0L+6luFngxDQqTDt0YQbToLM2iCBlLhHmlrLbYXonbRUh0taRu0MIGshfdiUKYgkTQZdEH9b/0nnXWNmjmnAEHnXOe52pF9ubH876uO2dngQUsYAljJSlcrKOzDlwf285TTNPkY91vJzxYmVgsxsUaGXHOOnCxstlHk5aVyw3xsS62IylW2s3ocjt0kfVz62AI+wFYfKyXimMNi2N9eggsZ2cJNKuFdVVdLJYbfCwnt8SwWPqBBSyGlQYWmoVmhQbrAbBEx5AdkwSWKBbGEDsLOyu4MQQWmgUsYOGvIRa88lgYQ7nGMMjbKcZ9Y/HzxrIOL4Xxb3l4gWE5j1XFygGLFrzKzaIEd9aBj+UEWMACFrCABSxgAQtYwAIWsIAFLGABC1jAAhawgAUsYMmHFXGJPyyOgypYvR1JHqXXC2uzWq2+oPRHXLIx3YpNyVNMSrPZLIcfKx6Pp1h0Xc9QYpREIpHywnpyiW7gze7vGnEJ++7D0fHxsYkJ+nDmJLtuqGkDAzclwHK0dEpAWHRFekg6rExQWDI1i6j8N6uPhzVKWNm/WJq6WNf9YFkyjWEq+Q8MF4vF5I3hnUhnFMfqA9bxNMsAFsYQWKdvZ2lolp9maVJgUTCG2FkhadYgsISxjEGMIV7BY2edcLOM/7zO0hTGyvv835CDdUpyjpOnM5Xot3q9fnCwtVWr1fb2fpVm5xtTvKcVHm/Yebdf3r2STm8uNvb3z7DsFgoF9t7W+S5OwoC1vLw0tbD+ceXVavH997m17d+z84sCWM+mbQ8s9gV1uh5L3L5nGD3d3ZJg/ZypOFg7xS9vn899eF0Swdr1btY1wkrpGQerh941HZOkWdGlHwvr5ZWd1SJhrTGshlCzXLGGqVlnO5slD1YlSs16Vy7TGLJmbZeEx1BdrNbOOmzWVyEs2/Za8BLsrJNMF7CABSxgAQtYwAIWsIAFLGABC1jAAhawgAUsYInlD6jJgSZIPE5uAAAAAElFTkSuQmCC" alt="Bukkit" />
          </div>
          <div class="flex flex-col justify-center">
            <span class="plugin-platform">Bukkit</span>
            <span class="plugin-platform-alternatives">Paper, Spigot etc.(1.8.8 to 1.20.x)</span>
          </div>
        </a>
        <a href="<?php echo leaderosWebsiteUrl() ?>/plugin/bungee" class="plugin-card" target="_blank">
          <div>
            <img width="60px" src="data:image/png;base64,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" alt="Bungeecord" />
          </div>
          <div class="flex flex-col justify-center">
            <span class="plugin-platform">Bungeecord</span>
            <span class="plugin-platform-alternatives">Waterfall, Flamecord etc.</span>
          </div>
        </a>
        <a href="<?php echo leaderosWebsiteUrl() ?>/plugin/velocity" class="plugin-card" target="_blank">
          <div>
            <img width="60px" src="data:image/png;base64,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" alt="Velocity" />
          </div>
          <div class="flex flex-col justify-center">
            <span class="plugin-platform">Velocity</span>
            <span class="plugin-platform-alternatives">Velocity (3.x)</span>
          </div>
        </a>
      </div>
    </div>
    <div>
      <p class="text-gray-800 font-medium mb-2">2. <?php e__('Configure the plugin') ?></p>
      <div class="plugin-config">
        <div class="absolute top-3 right-3" x-bind="tooltip('<?php e__('Copy') ?>')">
          <div data-clipboard-text="# Main settings
settings:
    # Url of your website
    url: <?php echo ("https://".$_SERVER["SERVER_NAME"]); ?>
    # API Key for request
    api-key: <?php echo settings('apiKey') ?>" class="copyConfig cursor-pointer w-8 h-8 flex items-center justify-center bg-gray-500/10 hover:bg-gray-500/30 border border-gray-200 dark:border-gray-600/20 rounded-lg">
            <i data-feather="copy" class="w-4 text-gray-800 copy-icon"></i>
            <i data-feather="tick-circle" class="w-4 text-success copied-icon" style="display: none;"></i>
          </div>
        </div>
        <div class="text-gray-300 font-medium mb-3 select-none">config.yml</div>
        <div class="text-gray-500"># Main settings</div>
        <div><span class="text-red-400 font-medium">settings</span><span class="text-blue-400">:</span></div>
        <div>
          <div class="text-gray-500 mt-1">&nbsp;&nbsp;&nbsp;&nbsp;# Url of your website</div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">url</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400"><?php echo settings('websiteURL'); ?></span></div>
          <div class="text-gray-500 mt-1">&nbsp;&nbsp;&nbsp;&nbsp;# API Key for request</div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">api-key</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">
              <?php echo settings('apiKey') ?>
            </span></div>
        </div>
      </div>
      <div class="plugin-config mt-2">
        <div class="absolute top-3 right-3" x-bind="tooltip('<?php e__('Copy') ?>')">
          <div data-clipboard-text="Connect:
    status: true
    server-token: <?php echo $server["consoleToken"] ?>" class="copyConfig cursor-pointer w-8 h-8 flex items-center justify-center bg-gray-500/10 hover:bg-gray-500/30 border border-gray-200 dark:border-gray-600/20 rounded-lg">
            <i data-feather="copy" class="w-4 text-gray-800 copy-icon"></i>
            <i data-feather="tick-circle" class="w-4 text-success copied-icon" style="display: none;"></i>
          </div>
        </div>
        <div class="text-gray-300 font-medium mb-3 select-none">modules.yml</div>
        <div><span class="text-red-400 font-medium">Connect</span><span class="text-blue-400">:</span></div>
        <div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">status</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">true</span></div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">serverToken</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400"><?php echo $server["consoleToken"] ?></span></div>
        </div>
      </div>
    </div>
  </div>
</section>
