<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.servers.index',
        'text' => t__('Servers')
    ],
		[
			'url' => url('dashboard.servers.edit', ['id' => $server["id"]]),
			'text' => $server["name"]
		],
    [
      'text' => t__('Plugin')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Plugin'),
    'category' => 'store.servers',
    'breadcrumbs' => $breadcrumbs
]) ?>

<?php $this->push('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
<script>
    var clipboard = new ClipboardJS('.copyConfig');
    clipboard.on('success', function(e) {
        e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'none';
        e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'block';
        setTimeout(function() {
            e.trigger.getElementsByClassName('copy-icon')[0].style.display = 'block';
            e.trigger.getElementsByClassName('copied-icon')[0].style.display = 'none';
        }, 2000);
    });
</script>
<?php $this->end(); ?>

<section class="los-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Plugin') ?>
    </h1>
  </div>
  <div class="card p-6 mt-10 grid gap-5">
    <div>
      <p class="text-gray-800 font-medium mb-2">1. <?php e__('Download LeaderOS Script') ?></p>
      <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <a href="https://www.leaderos.net/plugin/rust" class="plugin-card" target="_blank">
          <div>
            <img width="60px" src="data:image/png;base64,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" alt="Rust" />
          </div>
          <div class="flex flex-col justify-center">
            <span class="plugin-platform">LeaderOS Connect</span>
            <span class="plugin-platform-alternatives">
	            <?php e__('Click to Download') ?>
            </span>
          </div>
        </a>
      </div>
    </div>
    <div>
      <p class="text-gray-800 font-medium mb-2">2. <?php e__('Configure the script') ?></p>
      <div class="plugin-config">
        <div class="absolute top-3 right-3" x-bind="tooltip('<?php e__('Copy') ?>')">
          <div data-clipboard-text='{
  "Website URL": "<?php echo ("https://".$_SERVER["SERVER_NAME"]); ?>",
  "API Key": "<?php echo settings('apiKey') ?>",
  "Server Token": "<?php echo $server["consoleToken"] ?>",
  "Debug Mode": false,
  "Check Player Online": true
}' class="copyConfig cursor-pointer w-8 h-8 flex items-center justify-center bg-gray-500/10 hover:bg-gray-500/30 border border-gray-200 dark:border-gray-600/20 rounded-lg">
            <i data-feather="copy" class="w-4 text-gray-800 copy-icon"></i>
            <i data-feather="tick-circle" class="w-4 text-success copied-icon" style="display: none;"></i>
          </div>
        </div>
        <div class="text-gray-300 font-medium mb-3 select-none">config/LeaderosConnect.js</div>
        <div><span class="text-red-400 font-medium"></span><span class="text-white">{</span></div>
        <div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">"Website URL"</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">"<?php echo ("https://".$_SERVER["SERVER_NAME"]); ?>",</span></div>
          <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">"API Key"</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">
              "<?php echo settings('apiKey') ?>",
            </span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">"Server Token"</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">
              "<?php echo $server["consoleToken"] ?>",
            </span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">"Debug Mode"</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">false,</span></div>
	        <div>&nbsp;&nbsp;&nbsp;&nbsp;<span class="text-red-400 font-medium">"Check Player Online"</span><span class="text-blue-400">:</span> <span class="text-gray-500 dark:text-gray-400">true</span></div>
	        <div><span class="text-red-400 font-medium"></span><span class="text-white">}</span></div>
        </div>
      </div>
    </div>
  </div>
</section>
