<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Account Linking')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Providers'),
    'category' => 'settings.account-linking',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="border-b border-gray-600/10 pb-10 flex justify-between items-center">
        <h1 class="text-gray-950"><?php e__('Providers') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/using-leaderos/account-linking" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>
	
		<div class="mt-10 grid grid-cols-1 gap-4">
			<?php foreach ($providers as $provider): ?>
				<?php
					$providerIconPath = "/assets/core/images/auth-providers/";
					//$provider['icon'] = $providerIconPath . ($provider["slug"] == 'ingame' ? settings('gameType') . "_ingame" : $provider["slug"]) . ".svg";
					$provider['icon'] = $providerIconPath . ($provider["slug"] == 'ingame' ? "minecraft_ingame" : $provider["slug"]) . ".svg";
				?>
				<div class="card flex flex-col gap-3 p-4">
					<div class="flex justify-between">
						<div class="flex items-center gap-3">
							<img src="<?php echo $provider['icon'] ?>" alt="<?php echo $provider['name'] ?>" width="32px">
							<h5 class="text-gray-800"><?php e__($provider['name']) ?></h5>
						</div>
						
						<?php $this->insert('components/toggle', [
							'name' => 'module_' . $provider['id'],
							'default' => $provider['isEnabled'],
							'action' => 'await toggleAccountLinkingProvider(' . $provider['id'] . ')'
						]); ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
</section>