<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('API')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('API Settings'),
    'category' => 'settings.api',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('API Settings') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/api" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="mt-10 card p-6">
        <div class="grid gap-4">
          <div>
            <?php $this->insert('components/toggle', [
              'name' => 'isActive',
              'default' => old('isActive', settings('apiStatus')),
              'labelRight' => t__('API Status'),
              'action' => 'toggleApiStatus()'
            ]); ?>
          </div>
          <div>
            <label for="apiKey" class="form-label"><?php e__('API Key') ?>:</label>
            <div class="input-absolute-group-right">
              <input type="text" id="apiKey" class="form-control" name="apiKey" value="<?php echo settings('apiKey'); ?>" disabled>
              <div>
                <form action="<?php echo url('dashboard.settings.api.regenerateApiKey') ?>" method="post" data-submit-loading>
                  <?php _csrf(); ?>
                  <button type="submit" class="flex items-center justify-center gap-2 bg-red-500 text-white text-sm px-2.5 py-0.5 rounded-md">
                    <i class="stroke-gray-600 dark:stroke-white w-4" data-feather="refresh-2"></i>
                    <?php e__('Reset') ?>
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
    </div>
</section>