<?php
$breadcrumbs = [
  [
    'url' => 'dashboard.settings.index',
    'text' => t__('Settings')
  ],
  [
    'text' => t__('BirFatura')
  ]
];
$this->layout('layouts/main', [
  'title' => t__('BirFatura Settings'),
  'category' => 'settings.birfatura',
  'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
  <div class="los-page-heading">
    <h1 class="text-gray-950"><?php e__('BirFatura Settings') ?></h1>
    <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
            <?php e__('Back') ?>
    </a>
  </div>

  <?php _message(); ?>

  <form action="<?php echo url('dashboard.settings.birfatura.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
    <?php _method('PATCH'); ?>
    <div class="mt-10 card p-6 grid gap-4">
      <div>
        <label for="token" class="form-label"><?php e__('Token') ?>:</label>
        <div>
          <input type="text" id="token" class="form-control" name="token"
                 value="<?php _old('token', moduleSettings('birfatura', 'token')); ?>">
        </div>
      </div>
    </div>
    <div class="flex justify-end">
      <?php _csrf(); ?>
      <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
    </div>
  </form>
</section>