<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.settings.index',
			'text' => t__('Settings')
		],
		[
			'text' => t__('Credit')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('%module% Settings', ['%module%' => t__('Credit')]),
		'category' => 'settings.credit',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="los-container tight-container py-9">
	<div class="los-page-heading">
		<h1 class="text-gray-950"><?php e__('%module% Settings', ['%module%' => t__('Credit')]) ?></h1>
		<a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
			<?php e__('Back') ?>
		</a>
	</div>
	
	<?php _message(); ?>
	
	<form action="<?php echo url('dashboard.settings.credit.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
		<?php _method('PATCH'); ?>
		<div class="mt-10 card p-6 grid gap-4">
			<div>
				<label for="minPay" class="form-label"><?php e__('Min. Payment Amount') ?>:</label>
				<div>
					<input type="text" id="minPay" class="form-control" name="minPay" value="<?php _old('minPay', moduleSettings('credit', 'minPay')); ?>">
				</div>
			</div>
			<div>
				<label for="maxPay" class="form-label"><?php e__('Max Payment Amount') ?>:</label>
				<div>
					<input type="text" id="maxPay" class="form-control" name="maxPay" value="<?php _old('maxPay', moduleSettings('credit', 'maxPay')); ?>">
				</div>
			</div>
			<div>
				<label for="creditText" class="form-label"><?php e__('Credit Text') ?>:</label>
				<div>
					<input type="text" id="creditText" class="form-control" name="creditText" value="<?php _old('creditText', moduleSettings('credit', 'creditText')); ?>">
				</div>
			</div>
			<div x-data="{bonusCreditStatus: <?php _old('bonusCreditStatus', moduleSettings('credit', 'bonusCredit') == '0' ? 'false' : 'true') ?>}" class="grid gap-4">
				<div>
					<?php $this->insert('components/toggle', [
						'name' => 'bonusCreditStatus',
						'default' => old('bonusCredit', moduleSettings('credit', 'bonusCredit')) == '0' ? '0' : '1',
						'action' => 'bonusCreditStatus = !bonusCreditStatus',
						'labelRight' => t__('Bonus Credit')
					]); ?>
				</div>
				<div x-show="bonusCreditStatus" class="grid gap-4">
					<div>
						<label for="bonusCredit" class="form-label"><?php e__('Bonus Credit Percentage') ?>:</label>
						<div>
							<input type="text" id="bonusCredit" class="form-control" name="bonusCredit" value="<?php _old('bonusCredit', moduleSettings('credit', 'bonusCredit')); ?>">
						</div>
						<div class="form-text !text-xs" style="margin-top: 6px !important;">
							<?php e__('This is the percentage of the payment amount that will be given as bonus credit. For example, if you set it to 10, a payment of $50 will give the user $5 in bonus credit.') ?>
						</div>
					</div>
					<div>
						<label for="bonusCreditMinAmount" class="form-label"><?php e__('Min Payment Amount for Bonus Credit') ?>:</label>
						<div>
							<input type="text" id="bonusCreditMinAmount" class="form-control" name="bonusCreditMinAmount" value="<?php _old('bonusCreditMinAmount', moduleSettings('credit', 'bonusCreditMinAmount')); ?>">
						</div>
					</div>
					<div x-data="{bonusCreditExpiryStatus: '<?php _old('bonusCreditExpiryStatus', moduleSettings('credit', 'bonusCreditExpiryDate') == '1000-01-01 00:00:00' ? '0' : '1') ?>'}">
						<div>
							<label for="bonusCreditExpiryStatus" class="form-label">
								<?php e__('Bonus Credit Duration Status') ?>
							</label>
							<select x-data="select2Alpine()" x-init="changed('bonusCreditExpiryStatus', () => bonusCreditExpiryStatus = selected)" name="bonusCreditExpiryStatus" id="bonusCreditExpiryStatus">
								<option value="0" <?php _selected(old('bonusCreditExpiryStatus', moduleSettings('credit', 'bonusCreditExpiryDate') == '1000-01-01 00:00:00' ? '0' : '1') == '0'); ?>>
									<?php e__('Lifetime') ?>
								</option>
								<option value="1" <?php _selected(old('bonusCreditExpiryStatus', moduleSettings('credit', 'bonusCreditExpiryDate') == '1000-01-01 00:00:00' ? '0' : '1') == '1'); ?>>
									<?php e__('Temporary') ?>
								</option>
							</select>
						</div>
						<div class="mt-3" x-show="bonusCreditExpiryStatus === '1'">
							<label for="bonusCreditExpiryDate" class="form-label">
								<?php e__('Bonus Credit Duration') ?>
							</label>
							<div class="input-absolute-group">
								<i data-feather="calendar-2"></i>
								<input x-data="datePicker()" value="<?php _old('bonusCreditExpiryDate', moduleSettings('credit', 'bonusCreditExpiryDate') != '1000-01-01 00:00:00' ? moduleSettings('credit', 'bonusCreditExpiryDate') : null) ?>" type="text" id="bonusCreditExpiryDate" name="bonusCreditExpiryDate" class="form-control" placeholder="<?php e__('Select date') ?>">
							</div>
						</div>
					</div>
				</div>
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'showTermsCheckbox',
					'default' => old('showTermsCheckbox', moduleSettings('credit', 'showTermsCheckbox')) == '0' ? '0' : '1',
					'labelRight' => t__('Show Terms Checkbox in Checkout')
				]); ?>
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'creditPackageStatus',
					'default' => old('creditPackageStatus', moduleSettings('credit', 'creditPackageStatus')) == '0' ? '0' : '1',
					'labelRight' => t__('Credit Packages')
				]); ?>
			</div>
			<div>
				<?php $this->insert('components/toggle', [
					'name' => 'canSendCredits',
					'default' => old('canSendCredits', moduleSettings('credit', 'canSendCredits')) == '0' ? '0' : '1',
					'labelRight' => t__('Players Can Send Credits to Each Other')
				]); ?>
			</div>
		</div>
		<div class="flex justify-end">
			<?php _csrf(); ?>
			<button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
		</div>
	</form>
</section>