<?php
$breadcrumbs = [
    [
      'url' => 'dashboard.settings.index',
      'text' => t__('Settings')
    ],
    [
        'url' => 'dashboard.settings.currencies.index',
        'text' => t__('Currencies')
    ],
    [
        'text' => t__('Edit')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Editing %text%', ['%text%' => $currency['code']]),
    'category' => 'settings.currencies',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Editing %text%', ['%text%' => $currency['code']]) ?>
        </h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/currencies" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.currencies.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form x-data="{ autoUpdate: <?php echo old('autoUpdate', $currency["autoUpdate"]) == '1' ? 'true' : 'false'; ?> }" action="<?php echo url('dashboard.settings.currencies.update', ['id' => $currency['code']]) ?>" method="post" class="grid gap-4">
            <?php _method('PATCH') ?>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-2">
              <div>
                <label for="code" class="form-label">
                  <?php e__('Code') ?>
                </label>
                <input value="<?php echo $currency['code']; ?>" type="text" id="code" class="form-control" readonly>
              </div>
              <div>
                <label for="symbol" class="form-label">
                  <?php e__('Symbol') ?>
                </label>
                <input value="<?php echo $currency['symbol']; ?>" type="text" id="symbol" class="form-control" readonly>
              </div>
            </div>
            <div>
              <label for="label" class="form-label">
                <?php e__('Label') ?>
              </label>
              <input value="<?php _old('label', $currency['label']) ?>" type="text" id="label" name="label" class="form-control">
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-2">
              <div>
                <label for="prefix" class="form-label">
                  <?php e__('Prefix') ?>
                </label>
                <input value="<?php _old('prefix', $currency['prefix']) ?>" type="text" id="prefix" name="prefix" class="form-control">
              </div>
              <div>
                <label for="suffix" class="form-label">
                  <?php e__('Suffix') ?>
                </label>
                <input value="<?php _old('suffix', $currency['suffix']) ?>" type="text" id="suffix" name="suffix" class="form-control">
              </div>
            </div>
            <div>
              <label for="rate" class="form-label">
                <?php e__('Rate') ?>
              </label>
              <input value="<?php _old('rate', $currency['rate']) ?>" type="number" step="any" id="rate" name="rate" class="form-control" x-bind:readonly="autoUpdate">
            </div>
            <div>
              <?php $this->insert('components/toggle', [
                'name' => 'autoUpdate',
                'default' => old('autoUpdate', $currency["autoUpdate"]),
                'action' => 'autoUpdate = !autoUpdate',
                'labelRight' => t__('Auto Update')
              ]); ?>
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Save Changes') ?>
                </button>
            </div>
        </form>
    </div>
</section>

