<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Currencies')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Currencies'),
    'category' => 'settings.currencies',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Currencies') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/currencies" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>
	
	
		<div x-data="listjs()" id="listjs" class="grid mt-10">
			<div class="los-table-actions mb-4 grid">
				<div class="w-full">
					<label for="search" class="form-label">
						<?php e__('Search for %text%', ['%text%' => t__('Currencies')]) ?>
					</label>
					<div class="input-absolute-group">
						<i data-feather="search-normal"></i>
						<input type="text" class="form-control search" name="search" placeholder="<?php e__('Search...') ?>" autocomplete="off">
					</div>
				</div>
			</div>
			<div class="los-table">
				<table>
					<thead>
					<tr>
						<th>
							<div class="sort" data-sort="currency">
								<?php e__('Currency') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="symbol">
								<?php e__('Symbol') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="rate">
								<?php e__('Rate') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="label">
								<?php e__('Label') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="prefix">
								<?php e__('Prefix') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="suffix">
								<?php e__('Suffix') ?>
							</div>
						</th>
						<th>
							<div class="sort" data-sort="isActive">
								<?php e__('Status') ?>
							</div>
						</th>
						<th>
							<span class="sr-only">
								<?php e__('Actions') ?>
							</span>
						</th>
					</tr>
					</thead>
					<tbody class="list">
					<?php foreach ($currencies as $currency): ?>
						<tr>
							<td>
								<a href="<?php echo url('dashboard.settings.currencies.edit', ['id' => $currency['code']]) ?>" class="currency"><?php echo $currency['code'] ?></a>
								<?php if (settings('currency') == $currency["code"]): ?>
									<div class="badge badge-sm badge-primary ml-1">
										<?php e__('Default') ?>
									</div>
								<?php else: ?>
									<?php if ($currency['isActive'] == 1): ?>
										<form action="<?php echo url('dashboard.settings.currencies.set', ['id' => $currency['code']]) ?>" method="post" class="block text-xs text-gray-500 hover:!text-blue-500">
											<?php _method('PATCH'); ?>
											<?php _csrf(); ?>
											<button type="submit" class="!text-left">
												<?php e__('Set as default') ?>
											</button>
										</form>
									<?php endif; ?>
								<?php endif; ?>
							</td>
							<td class="symbol">
								<?php echo $currency['symbol'] ?>
							</td>
							<td class="rate">
								<?php echo $currency['rate'] ?>
							</td>
							<td class="label">
								<?php echo $currency['label'] ?>
							</td>
							<td class="prefix">
								<?php echo $currency['prefix'] ?>
							</td>
							<td class="suffix">
								<?php echo $currency['suffix'] ?>
							</td>
							<td class="isActive not">
								<?php if ($currency['isActive'] == 1): ?>
									<span class="badge badge-soft-success"><?php e__('Enabled') ?></span>
								<?php else: ?>
									<span class="badge badge-soft-danger"><?php e__('Disabled') ?></span>
								<?php endif; ?>
							</td>
							<td>
								<div class="flex items-center justify-end">
									<a href="<?php echo url('dashboard.settings.currencies.edit', ['id' => $currency['code']]) ?>" class="btn btn-sm link-primary">
										<?php e__('Edit') ?>
									</a>
									<?php if (settings('currency') != $currency["code"]): ?>
										<form action="<?php echo url('dashboard.settings.currencies.toggle', ['id' => $currency['code']]) ?>" method="post">
											<?php _csrf(); ?>
											<?php if ($currency['isActive'] == 1): ?>
												<button type="submit" class="btn btn-sm link-danger">
													<?php e__('Disable') ?>
												</button>
											<?php else: ?>
												<button type="submit" class="btn btn-sm link-success">
													<?php e__('Enable') ?>
												</button>
											<?php endif; ?>
										</form>
									<?php endif; ?>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		</div>
</section>

