<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('Discord Bot')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Discord Bot Settings'),
    'category' => 'settings.discord-bot-legacy',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Discord Bot Settings') ?></h1>
        <div class="flex gap-2">
	        <a href="<?php echo leaderosHelpUrl() ?>/integrations/discord-bot-legacy" class="btn btn-dark" target="_blank">
		        <?php e__('Help') ?>
	        </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
		        <?php e__('Back') ?>
	        </a>
        </div>
    </div>

    <?php _message(); ?>

    <div class="alert alert-info mt-10">
      <p class="dark:text-gray-300 font-medium">
        <?php e__('Redirect URLs') ?>:
      </p>
      <pre class="flex flex-col mt-2">
        <span><?php echo settings('websiteURL') . "/discord/login"; ?></span>
        <span><?php echo settings('websiteURL') . "/discord/link"; ?></span>
        <span><?php echo settings('websiteURL') . "/discord/unlink"; ?></span>
      </pre>
    </div>

    <form action="<?php echo url('dashboard.settings.discord-bot-legacy.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
        <?php _method('PATCH'); ?>
        <div class="mt-10 card p-6 grid gap-4">
            <div>
                <label for="discordClientID" class="form-label"><?php e__('Client ID') ?>:</label>
                <div>
                    <input type="text" id="clientID" class="form-control" name="clientID"
                           value="<?php _old('clientID', moduleSettings('discord', 'clientID')); ?>">
                </div>
            </div>
            <div>
                <label for="clientSecret" class="form-label"><?php e__('Client Secret') ?>:</label>
                <div>
                    <input type="text" id="clientSecret" class="form-control" name="clientSecret"
                           value="<?php _old('clientSecret', moduleSettings('discord', 'clientSecret')); ?>">
                </div>
            </div>
            <div>
                <label for="botToken" class="form-label"><?php e__('Bot Token') ?>:</label>
                <div>
                    <input type="text" id="botToken" class="form-control" name="botToken"
                           value="<?php _old('botToken', moduleSettings('discord', 'botToken')); ?>">
                </div>
            </div>
            <div>
                <label for="guildID" class="form-label"><?php e__('Server ID') ?>:</label>
                <div>
                    <input type="text" id="guildID" class="form-control" name="guildID"
                           value="<?php _old('guildID', moduleSettings('discord', 'guildID')); ?>">
                </div>
            </div>
            <div>
              <label for="joinServerStatus" class="form-label"><?php e__('Join Discord Server') ?>:</label>
              <div>
                <select x-data="select2Alpine()" name="joinServerStatus" id="joinServerStatus">
                  <option value="0" <?php _selected(old('joinServerStatus', moduleSettings('discord', 'joinServerStatus')) == '0'); ?>>
                    <?php e__('Disable') ?>
                  </option>
                  <option value="1" <?php _selected(old('joinServerStatus', moduleSettings('discord', 'joinServerStatus')) == '1'); ?>>
                    <?php e__('Enable') ?>
                  </option>
                </select>
              </div>
            </div>
            <div>
                <label for="everyoneRoleID" class="form-label"><?php e__('Everyone Role ID') ?>:</label>
                <div>
                    <input type="text" id="everyoneRoleID" class="form-control" name="everyoneRoleID"
                           value="<?php _old('everyoneRoleID', moduleSettings('discord', 'everyoneRoleID')); ?>">
                </div>
            </div>
            <div>
                <label for="syncedRoleID" class="form-label"><?php e__('Synced Role ID') ?>:</label>
                <div>
                    <input type="text" id="syncedRoleID" class="form-control" name="syncedRoleID"
                           value="<?php _old('syncedRoleID', moduleSettings('discord', 'syncedRoleID')); ?>">
                </div>
            </div>
            <div x-data="{roleSyncingStatus: '<?php _old('roleSyncingStatus', moduleSettings('discord', 'roleSyncingStatus')); ?>'}">
                <div>
                    <label for="roleSyncingStatus" class="form-label"><?php e__('Role Syncing') ?>:</label>
                    <div>
                        <select x-data="select2Alpine()" x-init="changed('roleSyncingStatus', () => roleSyncingStatus = selected)" name="roleSyncingStatus" id="roleSyncingStatus">
                            <option value="0" <?php _selected(old('roleSyncingStatus', moduleSettings('discord', 'roleSyncingStatus')) == '0'); ?>>
                                <?php e__('Disable') ?>
                            </option>
                            <option value="1" <?php _selected(old('roleSyncingStatus', moduleSettings('discord', 'roleSyncingStatus')) == '1'); ?>>
                                <?php e__('Enable') ?>
                            </option>
                        </select>
                    </div>
                </div>
            </div>
            <div x-data="{setNicknameStatus: '<?php _old('setNicknameStatus', moduleSettings('discord', 'setNicknameStatus')); ?>'}">
              <div>
                <label for="setNicknameStatus" class="form-label"><?php e__('Set Nickname') ?>:</label>
                <div>
                  <select x-data="select2Alpine()" x-init="changed('setNicknameStatus', () => setNicknameStatus = selected)" name="setNicknameStatus" id="setNicknameStatus">
                    <option value="0" <?php _selected(old('setNicknameStatus', moduleSettings('discord', 'setNicknameStatus')) == '0'); ?>>
                      <?php e__('Disable') ?>
                    </option>
                    <option value="1" <?php _selected(old('setNicknameStatus', moduleSettings('discord', 'setNicknameStatus')) == '1'); ?>>
                      <?php e__('Enable') ?>
                    </option>
                  </select>
                </div>
              </div>
            </div>
        </div>
        <div class="card p-6">
            <div x-data="{ticketStatus: '<?php _old('ticketStatus', moduleSettings('discord', 'ticketStatus')); ?>'}">
                <div>
                    <label for="ticketStatus" class="form-label"><?php e__('Support Tickets') ?>:</label>
                    <div>
                        <select x-data="select2Alpine()" x-init="changed('ticketStatus', () => ticketStatus = selected)" name="ticketStatus" id="ticketStatus">
                            <option value="0" <?php _selected(old('ticketStatus', moduleSettings('discord', 'ticketStatus')) == '0'); ?>>
                                <?php e__('Disable') ?>
                            </option>
                            <option value="1" <?php _selected(old('ticketStatus', moduleSettings('discord', 'ticketStatus')) == '1'); ?>>
                                <?php e__('Enable') ?>
                            </option>
                        </select>
                    </div>
                </div>
                <div x-show="ticketStatus === '1'">
                    <div class="mt-3">
                        <label for="ticketCategoryID" class="form-label"><?php e__('Ticket Discord Category ID') ?>:</label>
                        <div>
                            <input type="text" id="ticketCategoryID" class="form-control" name="ticketCategoryID"
                                   value="<?php _old('ticketCategoryID', moduleSettings('discord', 'ticketCategoryID')); ?>">
                        </div>
                    </div>
                    <div class="mt-3">
                        <label for="ticketStaffRoleID" class="form-label"><?php e__('Ticket Staff Role ID') ?>:</label>
                        <div>
                            <input type="text" id="ticketStaffRoleID" class="form-control" name="ticketStaffRoleID"
                                   value="<?php _old('ticketStaffRoleID', moduleSettings('discord', 'ticketStaffRoleID')); ?>">
                        </div>
                    </div>
                    <div class="mt-3">
                      <label for="ticketEmbedDetailsTemplate" class="form-label"><?php e__('Ticket Embed Message Template') ?>:</label>
                      <div>
                        <textarea name="ticketEmbedDetailsTemplate" id="ticketEmbedDetailsTemplate" rows="5" class="form-control"><?php _old('ticketEmbedDetailsTemplate', moduleSettings('discord', 'ticketEmbedDetailsTemplate')); ?></textarea>
                      </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex justify-end">
            <?php _csrf(); ?>
            <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
        </div>
    </form>
</section>