<?php
$breadcrumbs = [
	[
		'url' => 'dashboard.settings.index',
		'text' => t__('Settings')
	],
	[
		'text' => t__('Discord Bot')
	]
];
$this->layout('layouts/main', [
	'title' => t__('Discord Bot'),
	'category' => 'settings.discord-bot',
	'breadcrumbs' => $breadcrumbs
]) ?>

<?php if (!$isLinked): ?>
	<section class="los-container py-9">
		<?php _message(); ?>
		<div class="center flex-col mt-20 mb-32">
			
			<i class="w-16 h-16 stroke-gray-600" data-feather="discord"></i>
			
			<h3 class="mt-8 text-gray-800">
				<?php e__('Discord Bot is not connected') ?>
			</h3>
			<p class="text-gray-500 mt-2 max-w-lg mx-auto text-center">
				<?php e__('You need to connect your Discord server to use this feature.') ?>
			</p>
			<div class="mt-8 flex gap-2">
				<a href="<?php echo url('dashboard.settings.discord-bot.link'); ?>" class="btn btn-success"><?php e__('Connect Discord Server') ?></a>
			</div>
		</div>
	</section>
<?php else: ?>
	<section class="py-9 los-container tight-container">
		<div class="los-page-heading">
			<h1 class="text-gray-950">
				<?php e__('Discord Bot Settings') ?>
			</h1>
		</div>
		
		<?php _message(); ?>
		
		<div class="card p-6 mt-10">
			<form action="<?php echo url('dashboard.settings.discord-bot.update') ?>" method="post" class="grid gap-4">
				<?php _method('PATCH') ?>
				
				<div>
					<label for="guildID" class="form-label"><?php e__('Server ID') ?>:</label>
					<div class="input-absolute-group-right">
						<input type="text" id="guildID" class="form-control" value="<?php echo moduleSettings('discord_bot', 'guildID'); ?>" readonly>
						<div x-data="unlinkDiscordBot('<?php echo url('dashboard.settings.discord-bot.reset') ?>')">
							<button
								type="button"
								class="btn btn-danger flex items-center gap-2 !text-sm !px-2.5 !py-0.5 rounded-md"
								@click="unlinkDiscordBotRequest()"
								x-bind:disabled="isLoading"
								:class="isLoading ? 'opacity-50 pointer-events-none' : ''"
							>
								<i class="stroke-gray-600 dark:stroke-white w-4" data-feather="link-21"></i>
								<?php e__('Unlink Bot') ?>
							</button>
						</div>
					</div>
				</div>
				
				<?php $this->insert('components/toggle', [
					'name' => 'syncNames',
					'default' => old('syncNames', moduleSettings('discord_bot', 'syncNames')),
					'labelRight' => t__('Sync Username'),
				]); ?>
				
				<div class="flex justify-end">
					<?php _csrf(); ?>
					<button type="submit" class="btn btn-success">
						<?php e__('Save Changes') ?>
					</button>
				</div>
			</form>
		</div>
		
		<div class="card p-6 mt-6">
			<form action="<?php echo url('dashboard.settings.discord-bot.linkRoles') ?>" method="post" class="grid">
				<div>
					<div class="flex justify-between items-center">
						<div class="card-title">
							<?php e__('Role Links') ?>
						</div>
					</div>
					<table class="mt-3 table">
						<colgroup>
							<col style="width: 40%;">
							<col style="width: 60%;">
						</colgroup>
						<thead class="">
						<tr class="table-header !text-xs !text-gray-500">
							<th scope="col" class="!text-left">
								<?php e__('Role') ?>
							</th>
							<th scope="col" class="!text-left">
								<?php e__('Discord Role ID') ?>
							</th>
						</tr>
						</thead>
						<tbody class="divide-y divide-gray-200/20 text-center">
						<?php foreach ($websiteRoles as $websiteRole): ?>
							<tr>
								<td class="!text-left !pl-0">
									<input type="text" class="form-control" value="<?php echo $websiteRole["name"]; ?>" readonly>
									<input type="hidden" class="form-control" name="roles[]" value="<?php echo $websiteRole["id"]; ?>">
								</td>
								<td class="!text-left !px-0">
									<input type="text" class="form-control" name="discordRoles[]" value="<?php echo $websiteRole["discordRoleID"]; ?>">
								</td>
							</tr>
						<?php endforeach; ?>
						</tbody>
					</table>
				</div>
				
				<div class="flex justify-end">
					<?php _csrf(); ?>
					<button type="submit" class="btn btn-success">
						<?php e__('Save Changes') ?>
					</button>
				</div>
			</form>
		</div>
		
	</section>
<?php endif; ?>
