<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.settings.index',
			'text' => t__('Settings')
		],
		[
			'text' => t__('Discord Bot')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('Connect Discord Server'),
		'category' => 'settings.discord-bot',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<section class="py-9 los-container tight-container">
  <div class="los-page-heading">
    <h1 class="text-gray-950">
      <?php e__('Connect Discord Server') ?>
    </h1>
	  <a href="<?php echo leaderosHelpUrl() ?>/integrations/discord-bot" class="btn btn-dark" target="_blank">
		  <?php e__('Help') ?>
	  </a>
  </div>
	
	<?php _message(); ?>
	
  <div class="card p-6 mt-10 grid gap-8">
    <div>
      <h5 class="text-gray-800 font-medium mb-4">1. <?php e__('Invite the official LeaderOS Discord Bot to your Discord server.') ?></h5>
	    <a href="<?php echo $inviteLink ?>" class="btn btn-primary !px-5 !py-3" target="_blank">
		    <?php e__('Invite the Bot') ?>
	    </a>
    </div>
	  <div>
		  <h5 class="text-gray-800 font-medium mb-2">2. <?php e__('Run the following command in your Discord server to link the bot to your server.') ?></h5>
		  <div class="input-group">
			  <div class="input-group-prepend">
				  <div class="input-group-text">
					  /link
				  </div>
			  </div>
			  <input value="<?php echo $token ?>" type="text" class="form-control" readonly>
		  </div>
	  </div>
	  <div>
		  <h5 class="text-gray-800 font-medium mb-2">3. <?php e__('Give our bot permission to assign roles.') ?></h5>
		  <p class="text-gray-500">
			  <?php e__('Go to Discord App > Server Settings > Roles and move the LeaderOS role to the top.') ?>
		  </p>
	  </div>
  </div>
	<form action="<?php echo url('dashboard.settings.discord-bot.validate') ?>" method="post" class="flex justify-end mt-4">
		<?php _csrf(); ?>
		<button type="submit" class="btn btn-success !px-5 !py-3"><?php e__('Complete') ?></button>
	</form>
</section>
