<?php
	$breadcrumbs = [
		[
			'url' => 'dashboard.settings.index',
			'text' => t__('Settings')
		],
		[
			'text' => t__('Email Templates')
		]
	];
	$this->layout('layouts/main', [
		'title' => t__('Email Templates'),
		'category' => 'settings.email-templates',
		'breadcrumbs' => $breadcrumbs
	]) ?>

<?php $this->push('scripts') ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.10.7/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '.email-template-editor',
			<?php if ($lang != "en"): ?>
        language_url : '<?php echo "/apps/dashboard/public/assets/js/tinymce/langs/$lang.js"; ?>',
        language: '<?php echo $lang; ?>',
			<?php endif; ?>
        plugins: 'code link image fullscreen preview fullpage autosave',
        toolbar: 'formatselect | bold italic underline strikethrough backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | image  fullscreen preview code',
        menubar: '',
        content_style: 'table:not([cellpadding]) td,table:not([cellpadding]) th {padding: 0;}',
        elementpath: false,
    });
</script>
<?php $this->end(); ?>
<style>
    .tox-tinymce {
        min-height: 550px !important;
    }
</style>

<section class="los-container tighter-container py-9">
	<div class="los-page-heading">
		<h1 class="text-gray-950"><?php e__('Email Templates') ?></h1>
		<div class="flex gap-2">
			<a href="<?php echo leaderosHelpUrl() ?>/settings/email-templates" class="btn btn-dark" target="_blank">
				<?php e__('Help') ?>
			</a>
			<a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
				<?php e__('Back') ?>
			</a>
		</div>
	</div>
	
	<?php _message(); ?>
	
	<div class="grid lg:grid-cols-10 gap-4 mt-10">
		<div class="lg:col-span-3">
			<div class="card tab-container">
				<div class="px-4" style="max-height: 700px;overflow-y: auto">
					<?php foreach ($templates as $item): ?>
						<a href="?tab=<?php echo $item["id"]; ?>" class="tab-item block <?php echo $item["id"] == $template["id"] ? 'active' : null ?>">
							<?php echo $item["label"]; ?>
						</a>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
		<div class="lg:col-span-7">
			<div class="card p-6">
				<form action="<?php echo url('dashboard.settings.email-templates.update', ['id' => $template['id']]) ?>" method="post">
					<?php _method('PATCH'); ?>
					
					<div class="grid gap-4">
						<div>
							<label for="title" class="form-label">
								<?php e__('Title') ?>
							</label>
							<input type="text" name="<?php echo $template["title"]["name"]; ?>" value="<?php _old($template["title"]["name"], $template["title"]["value"]) ?>" id="title" class="form-control">
						</div>
						<div>
							<label for="content" class="form-label">
								<?php e__('Content') ?>
							</label>
							<textarea class="form-control email-template-editor" name="<?php echo $template["content"]["name"]; ?>" id="<?php echo $template["content"]["name"]; ?>"><?php _old($template["content"]["name"], $template["content"]["value"]) ?></textarea>
						</div>
						<div class="grid mt-2 gap-2">
							<?php foreach ($template["variables"] as $variable): ?>
								<small class="text-gray-400/75">
									<strong><?php echo $variable["name"] ?>:</strong> <?php echo $variable["value"] ?>
								</small>
							<?php endforeach; ?>
						</div>
					</div>
					
					<div class="flex justify-end">
						<?php _csrf(); ?>
						<button type="submit" class="btn btn-success">
							<?php e__('Save Changes') ?>
						</button>
					</div>
				</form>
			</div>
		</div>
	</div>
</section>
