<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'text' => t__('General')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('General Settings'),
    'category' => 'settings.general',
    'breadcrumbs' => $breadcrumbs
]) ?>

<style>
    .site-icon-section {
        --site-icon-removal: #b32d2e
    }

    .site-icon-preview {
        --site-icon-input-browser-button: #8c8f94;
        --site-icon-input-border: #e5e7ebbf;
        --site-icon-preview-background: #fff;
        --site-icon-preview-browser-top: #dcdcde;
        --site-icon-preview-browser-bottom: #a7aaad;
        --site-icon-preview-browser-border: rgba(255, 255, 255, 0.2);
        --site-icon-address-bar-background: #f0f0f1;
        --site-icon-address-bar-close: #646970;
        --site-icon-address-bar-text: #3c434a;
        --site-icon-shadow-1: rgba(0, 0, 0, 0.1);
        --site-icon-shadow-2: rgba(0, 0, 0, 0.2);
        --site-icon-shadow-3: rgba(0, 0, 0, 0.5);
        direction: initial;
        display: flex;
        height: 60px;
        padding: 8px 0 0 8px;
        align-items: flex-start;
        position: relative;
        overflow: hidden;
        box-sizing: border-box;
        border: 1px solid var(--site-icon-input-border);
        border-radius: 4px;
        background-color: var(--site-icon-preview-background);
        width: 350px
    }

    .dark .site-icon-preview {
        --site-icon-input-browser-button: #8c8f94;
        --site-icon-input-border: #1f1f1f;
        --site-icon-preview-browser-top:#2c3338;
        --site-icon-preview-browser-bottom: #111;
        --site-icon-address-bar-background: #3c434a;
        --site-icon-address-bar-close: #f0f0f1;
        --site-icon-address-bar-text: #f0f0f1;
        --site-icon-preview-background: #0C0C0D;
    }
    .site-icon-preview.settings {
        height: 88px;
        padding: 16px 0 0 16px;
        width: 100%;
        margin: 0 0 8px 0
    }

    .site-icon-preview.crop {
        width: 258px;
        height: 100%;
        display: grid;
        grid-template-columns: 8px 1fr;
        grid-template-rows: 64px 1fr;
        padding-left: 0;
        row-gap: 16px;
        direction: inherit
    }

    .site-icon-preview.hidden {
        display: none
    }

    .site-icon-preview .direction-wrap {
        grid-template-columns: 44px 1fr;
        gap: 8px;
        display: grid;
        direction: ltr;
        height: 100%;
        width: 100%
    }

    .site-icon-preview.settings .direction-wrap {
        grid-template-columns: 58px 1fr;
        gap: 16px
    }

    .site-icon-preview:after {
        --after-size: 150%;
        aspect-ratio: 1/1;
        content: "";
        display: block;
        position: absolute;
        top: 0;
        left: 0;
        width: var(--after-size);
        transform: translate(calc(var(--after-size) * -.125),calc(var(--after-size) * -.125));
        filter: blur(5px);
        opacity: .5;
    }

    .site-icon-preview .app-icon-preview {
        aspect-ratio: 1/1;
        flex-shrink: 0;
        width: 100%;
        z-index: 1
    }

    .site-icon-preview-browser {
        display: flex;
        padding: 4px 4px 0 12px;
        align-items: flex-start;
        gap: 16px;
        flex: 1 0 0;
        z-index: 1;
        border-top-left-radius: 10px;
        border-top: 1px solid var(--site-icon-preview-browser-border);
        border-left: 1px solid var(--site-icon-preview-browser-border);
        background: linear-gradient(180deg,var(--site-icon-preview-browser-top) 0,var(--site-icon-preview-browser-bottom) 100%);
        box-shadow: 0 10px 22px 0 var(--site-icon-shadow-2)
    }

    .site-icon-preview .browser-buttons {
        width: 48px;
        height: 40px;
        fill: var(--site-icon-input-browser-button)
    }

    .site-icon-preview-tab {
        padding: 8px;
        align-items: center;
        gap: 8px;
        flex: 1 0 0;
        border-radius: 4px;
        background-color: var(--site-icon-address-bar-background);
        box-shadow: 0 1px 3px 0 var(--site-icon-shadow-1);
        display: grid;
        grid-template-columns: 24px auto 24px
    }

    .site-icon-preview-browser .browser-icon-preview {
        box-shadow: 0 0 20px 0 var(--site-icon-shadow-1)
    }

    .site-icon-preview-tab>img,.site-icon-preview-tab>svg {
        width: 24px;
        height: 24px
    }

    .site-icon-preview-tab>svg {
        fill: var(--site-icon-address-bar-close)
    }

    .site-icon-preview-site-title {
        color: var(--site-icon-address-bar-text);
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        font-weight: 500
    }

    .site-icon-preview-crop-modal .image-preview-wrap.app-icon-preview {
        width: 64px;
        height: 64px;
        margin: 0;
        grid-column: 2
    }

    .site-icon-preview-crop-modal .site-icon-preview-browser {
        grid-column: 2
    }

    .site-icon-preview-crop-modal .image-preview-wrap {
        overflow: hidden;
        aspect-ratio: 1/1
    }

    .site-icon-preview-crop-modal .image-preview-wrap.browser {
        width: 24px;
        height: 24px
    }

    button.reset.remove-site-icon {
        color: var(--site-icon-removal);
        text-decoration: none;
        border-color: transparent;
        box-shadow: none;
        background: 0 0
    }

    button.reset.remove-site-icon:focus,button.reset.remove-site-icon:hover {
        background: var(--site-icon-removal);
        color: #fff;
        border-color: var(--site-icon-removal);
        box-shadow: 0 0 0 1px var(--site-icon-removal)
    }

    .site-icon-action-buttons {
        display: flex;
        flex-wrap: wrap;
        gap: 10px
    }

</style>

<section class="los-container tight-container py-9">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('General Settings') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/general" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="mt-10 card p-6">
        <form action="<?php echo url('dashboard.settings.general.update') ?>" method="post" enctype="multipart/form-data" class="grid gap-4">
            <?php _method('PATCH'); ?>
            <div>
              <label for="inputWebsiteURL" class="form-label"><?php e__('Website URL') ?>:*</label>
              <div>
                <input type="text" id="inputWebsiteURL" class="form-control" name="websiteURL" value="<?php _old('websiteURL', settings('websiteURL')); ?>" required>
              </div>
            </div>
            <div>
                <label for="inputServerName" class="form-label"><?php e__('Server Name') ?>:*</label>
                <div>
                    <input type="text" id="inputServerName" class="form-control" name="serverName" value="<?php _old('serverName', settings('serverName')); ?>" required>
                </div>
            </div>
            <div>
                <label for="inputSiteSlogan" class="form-label"><?php e__('Site Title') ?>:*</label>
                <div>
                    <input type="text" id="inputSiteSlogan" class="form-control" name="siteSlogan" value="<?php _old('siteSlogan', settings('siteSlogan')); ?>" required>
                </div>
            </div>
            <div>
                <label for="inputServerIP" class="form-label"><?php e__('Server IP') ?>:</label>
                <div>
                    <input type="text" id="inputServerIP" class="form-control" name="serverIP" value="<?php _old('serverIP', settings('serverIP')); ?>">
                </div>
            </div>
            <div>
                <label for="inputServerVersion" class="form-label"><?php e__('Server Version') ?>:</label>
                <div>
                    <input type="text" id="inputServerVersion" class="form-control" name="serverVersion" value="<?php _old('serverVersion', settings('serverVersion')); ?>">
                </div>
            </div>
            <div>
                <label for="textareaSiteDescription" class="form-label"><?php e__('Google Description') ?>:</label>
                <div>
                    <textarea id="textareaSiteDescription" class="form-control" name="siteDescription"><?php _old('siteDescription', settings('siteDescription')); ?></textarea>
                </div>
            </div>
            <div>
                <label for="inputFacebookURL" class="form-label">Facebook URL:</label>
                <div>
                    <input type="text" id="inputFacebookURL" class="form-control" name="facebookUrl" value="<?php _old('facebookUrl', settings('facebookUrl')); ?>">
                </div>
            </div>
            <div>
                <label for="inputXURL" class="form-label">Twitter URL:</label>
                <div>
                    <input type="text" id="inputXURL" class="form-control" name="xUrl" value="<?php _old('xUrl', settings('xUrl')); ?>">
                </div>
            </div>
            <div>
                <label for="inputInstagramURL" class="form-label">Instagram URL:</label>
                <div>
                    <input type="text" id="inputInstagramURL" class="form-control" name="instagramUrl" value="<?php _old('instagramUrl', settings('instagramUrl')); ?>">
                </div>
            </div>
            <div>
                <label for="inputTiktokURL" class="form-label">TikTok URL:</label>
                <div>
                    <input type="text" id="inputTiktokURL" class="form-control" name="tiktokUrl" value="<?php _old('tiktokUrl', settings('tiktokUrl')); ?>">
                </div>
            </div>
            <div>
                <label for="inputYoutubeURL" class="form-label">YouTube URL:</label>
                <div>
                    <input type="text" id="inputYoutubeURL" class="form-control" name="youtubeUrl" value="<?php _old('youtubeUrl', settings('youtubeUrl')); ?>">
                </div>
            </div>
            <div>
                <label for="inputDiscordURL" class="form-label">Discord URL:</label>
                <div>
                    <input type="text" id="inputDiscordURL" class="form-control" name="discordUrl" value="<?php _old('discordUrl', settings('discordUrl')); ?>">
                </div>
            </div>
		        <div x-data="textEditor()">
			        <label for="textareaAbout" class="form-label"><?php e__('About Us') ?>:</label>
			        <div class="mt-2">
				        <textarea x-ref="textEditor" class="form-control" name="about" id="textareaAbout"><?php echo settings('about') ?></textarea>
			        </div>
		        </div>
            <div x-data="image">
                <label for="fileFavicon" class="form-label"><?php e__('Site Icon') ?>:</label>
		            <div id="site-icon-preview" class="site-icon-preview settings">
			            <div class="direction-wrap" x-bind="imageContainer">
				            <img id="app-icon-preview" x-show="imagePreview === null" src="<?php echo '/favicon.ico?cache='.settings('updatedAt') ?>" class="app-icon-preview" alt="App icon preview: The current image has no alternative text. The file name is: cropped-leaderos-icon-scaled-1.png">
				            <img id="app-icon-preview" x-show="imagePreview !== null" :src="imagePreview" class="app-icon-preview" alt="App icon preview: The current image has no alternative text. The file name is: cropped-leaderos-icon-scaled-1.png">
				            <div class="site-icon-preview-browser">
					            <svg role="img" aria-hidden="true" fill="none" xmlns="http://www.w3.org/2000/svg" class="browser-buttons">
						            <path fill-rule="evenodd" clip-rule="evenodd" d="M0 20a6 6 0 1 1 12 0 6 6 0 0 1-12 0Zm18 0a6 6 0 1 1 12 0 6 6 0 0 1-12 0Zm24-6a6 6 0 1 0 0 12 6 6 0 0 0 0-12Z"></path>
					            </svg>
					            <div class="site-icon-preview-tab">
						            <img id="browser-icon-preview" x-show="imagePreview === null" src="<?php echo '/favicon.ico?cache='.settings('updatedAt') ?>" class="browser-icon-preview" alt="Browser icon preview: The current image has no alternative text. The file name is: cropped-leaderos-icon-scaled-1.png">
						            <img id="browser-icon-preview" x-show="imagePreview !== null" :src="imagePreview" class="browser-icon-preview" alt="Browser icon preview: The current image has no alternative text. The file name is: cropped-leaderos-icon-scaled-1.png">
						            <div class="site-icon-preview-site-title" id="site-icon-preview-site-title" aria-hidden="true">My Website</div>
						            <svg role="img" aria-hidden="true" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-button">
							            <path d="M12 13.0607L15.7123 16.773L16.773 15.7123L13.0607 12L16.773 8.28772L15.7123 7.22706L12 10.9394L8.28771 7.22705L7.22705 8.28771L10.9394 12L7.22706 15.7123L8.28772 16.773L12 13.0607Z"></path>
						            </svg>
					            </div>
				            </div>
			            </div>
		            </div>
	              <div class="mb-4 text-gray-400/75 text-sm">
		              <?php e__('The Site Icon is what you see in browser tabs and bookmark bars. It should be square and at least 512 by 512 pixels.') ?>
	              </div>
	              <div class="">
			            <label for="favicon" class="btn btn-dark"><?php e__('Select an image') ?></label>
		              <input id="favicon" name="favicon" x-bind="imageInput" type="file" accept="image/*" class="hidden">
	              </div>
            </div>
            <div class="flex justify-end mt-10">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success"><?php e__('Save Changes') ?></button>
            </div>
        </form>
    </div>
</section>