<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Settings'),
    'category' => 'settings',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950">
            <?php e__('Settings') ?>
        </h1>
    </div>

    <div class="">
        <div class="mt-10 grid md:grid-cols-2 -mx-6">
            <a href="<?php echo url('dashboard.settings.general.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="setting-5"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('General Settings') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Change general settings and customize your website.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.system.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="cpu"></i>
                </div>
                <div>
                <span class="text-gray-700 text-lg font-medium">
                    <?php e__('System Settings') ?>
                </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Change system settings and customize your website.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.payment-gateways.index'); ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="card-add"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('Payment Methods') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage the payment methods and get paid.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.currencies.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="money-send"></i>
                </div>
                <div>
                <span class="text-gray-700 text-lg font-medium">
                    <?php e__('Currencies') ?>
                </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage the currencies and exchange rates.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.seo.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="search-status"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('SEO Settings') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Optimize your website for search engines from here.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.languages') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="language-square"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('Languages') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage languages and translations from here.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>
	        
            <?php if (!moduleIsDisabled('account_linking')): ?>
                <a href="<?php echo url('dashboard.settings.account-linking.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                    <div class="center w-16 h-16 card shrink-0">
                        <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="link-21"></i>
                    </div>
                    <div>
                        <span class="text-gray-700 text-lg font-medium">
                            <?php e__('Account Linking') ?>
                        </span>
                        <p class="mt-0.5 text-gray-400/75 text-sm">
                            <?php e__('Enable users to link third-party accounts such as Discord, Steam, and more.') ?>
                        </p>
                    </div>

                    <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                        <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                </a>
            <?php endif; ?>

            <a href="<?php echo url('dashboard.discord-webhooks.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="webhook"></i>
                </div>
                <div>
                <span class="text-gray-700 text-lg font-medium">
                    <?php e__('Discord Webhooks') ?>
                </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage your Discord webhooks for sending notifications to your Discord server.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.smtp.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="directbox-send"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('SMTP') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Set up your SMTP connection to send emails to your users.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>
	        
	        <a href="<?php echo url('dashboard.settings.email-templates.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
		        <div class="center w-16 h-16 card shrink-0">
			        <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="directbox-notif"></i>
		        </div>
		        <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('Email Templates') ?>
                    </span>
			        <p class="mt-0.5 text-gray-400/75 text-sm">
				        <?php e__('Customize the email templates that are sent to your users.') ?>
			        </p>
		        </div>
		        
		        <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
			        <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
				        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
				        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
			        </svg>
		        </div>
	        </a>

            <?php if (!moduleIsDisabled('discord')): ?>
                <a href="<?php echo url('dashboard.settings.discord-legacy.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                    <div class="center w-16 h-16 card shrink-0">
                        <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="discord"></i>
                    </div>
                    <div>
                  <span class="text-gray-700 text-lg font-medium">
                      <?php e__('Discord Bot (Legacy)') ?>
                  </span>
                        <p class="mt-0.5 text-gray-400/75 text-sm">
                            <?php e__('Manage your Discord bot settings.') ?>
                        </p>
                    </div>

                    <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                        <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                </a>
            <?php endif; ?>
	        
		        <?php if (!moduleIsDisabled('discord_bot')): ?>
			        <a href="<?php echo url('dashboard.settings.discord-bot.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
				        <div class="center w-16 h-16 card shrink-0">
					        <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="discord"></i>
				        </div>
				        <div>
					        <span class="text-gray-700 text-lg font-medium">
						        <?php e__('Discord Bot') ?>
					        </span>
					        <p class="mt-0.5 text-gray-400/75 text-sm">
						        <?php e__('Manage your Discord bot settings.') ?>
					        </p>
				        </div>
				        
				        <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
					        <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
						        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
					        </svg>
				        </div>
			        </a>
		        <?php endif; ?>

            <a href="<?php echo url('dashboard.modules.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="category"></i>
                </div>
                <div>
                      <span class="text-gray-700 text-lg font-medium">
                          <?php e__('Modules') ?>
                      </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage modules and install new modules.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.settings.api.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="data"></i>
                </div>
                <div>
                      <span class="text-gray-700 text-lg font-medium">
                          <?php e__('API Settings') ?>
                      </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage API Keys and settings.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>

            <a href="<?php echo url('dashboard.updates.index') ?>" class="py-4 px-6 rounded-xl flex gap-6 items-center transition hover:bg-gray-600/5 group">
                <div class="center w-16 h-16 card shrink-0">
                    <i class="w-6 h-6 stroke-2 stroke-gray-800" data-feather="refresh-2"></i>
                </div>
                <div>
                    <span class="text-gray-700 text-lg font-medium">
                        <?php e__('Updates') ?>
                    </span>
                    <p class="mt-0.5 text-gray-400/75 text-sm">
                        <?php e__('Manage update settings and update your website.') ?>
                    </p>
                </div>

                <div class="ml-auto opacity-0 -translate-x-4 transition-all group-hover:opacity-100 group-hover:translate-x-0">
                    <svg class="w-7 stroke-gray-400" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.75 11.7258L4.75 11.7258" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M13.7002 5.70143L19.7502 11.7254L13.7002 17.7504" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </a>
        </div>
    </div>
</section>
