<?php
$breadcrumbs = [
    [
        'url' => 'dashboard.settings.index',
        'text' => t__('Settings')
    ],
    [
        'url' => 'dashboard.settings.languages.index',
        'text' => t__('Languages')
    ],
    [
        'text' => t__('Add')
    ]
];
$this->layout('layouts/main', [
    'title' => t__('Add Language'),
    'category' => 'settings.languages',
    'breadcrumbs' => $breadcrumbs
]) ?>

<section class="py-9 los-container tight-container">
    <div class="los-page-heading">
        <h1 class="text-gray-950"><?php e__('Add Language') ?></h1>
		    <div class="flex gap-2">
			    <a href="<?php echo leaderosHelpUrl() ?>/settings/languages" class="btn btn-dark" target="_blank">
				    <?php e__('Help') ?>
			    </a>
	        <a href="<?php echo url('dashboard.settings.languages.index') ?>" class="btn btn-default">
	            <?php e__('Back') ?>
	        </a>
		    </div>
    </div>

    <?php _message(); ?>

    <div class="card p-6 mt-10">
        <form action="<?php echo url('dashboard.settings.languages.store') ?>" method="post" class="grid gap-4">
            <div>
                <label for="languageCode" class="form-label">
                    <?php e__('Language Code') ?>
                </label>
                <input value="<?php _old('languageCode') ?>" type="text" id="languageCode" name="languageCode" class="form-control">
            </div>
            <div>
                <label for="languageName" class="form-label">
                    <?php e__('Name') ?>
                </label>
                <input value="<?php _old('languageName') ?>" type="text" id="languageName" name="languageName" class="form-control">
            </div>

            <div class="flex justify-end">
                <?php _csrf(); ?>
                <button type="submit" class="btn btn-success">
                    <?php e__('Add Language') ?>
                </button>
            </div>
        </form>
    </div>
</section>

